/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.ContextualSAXHandler;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.codehaus.groovy.grails.resolve.LastModifiedResolvedResource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SnapshotAwareM2Resolver
extends IBiblioResolver {
    private static final String M2_PER_MODULE_PATTERN = "[revision]/[artifact]-[revision](-[classifier]).[ext]";
    private static final String M2_PATTERN = "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]";

    public SnapshotAwareM2Resolver() {
        this.setM2compatible(true);
        this.setAlwaysCheckExactRevision(true);
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        if (this.isM2compatible() && this.isUsepoms()) {
            ModuleRevisionId mrid = dd.getDependencyRevisionId();
            mrid = this.convertM2IdForResourceSearch(mrid);
            ResolvedResource rres = null;
            if (dd.getDependencyRevisionId().getRevision().endsWith("SNAPSHOT") && (rres = this.findSnapshotDescriptor(dd, data, mrid)) != null) {
                return rres;
            }
            rres = this.findResourceUsingPatterns(mrid, this.getIvyPatterns(), DefaultArtifact.newPomArtifact((ModuleRevisionId)mrid, (Date)data.getDate()), this.getRMDParser(dd, data), data.getDate());
            return rres;
        }
        return null;
    }

    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        this.ensureConfigured(this.getSettings());
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        ResolvedResource rres = null;
        if (artifact.getId().getRevision().endsWith("SNAPSHOT") && this.isM2compatible() && (rres = this.findSnapshotArtifact(artifact, date, mrid)) != null) {
            return rres;
        }
        return this.findResourceUsingPatterns(mrid, this.getArtifactPatterns(), artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    private ResolvedResource findSnapshotArtifact(Artifact artifact, Date date, ModuleRevisionId mrid) {
        SnapshotRevision rev = this.findSnapshotRevision(mrid);
        if (rev != null) {
            String pattern = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + rev.uniqueRevision);
            ResolvedResource uniqueResource = this.findResourceUsingPattern(mrid, pattern, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
            if (uniqueResource != null) {
                return new LastModifiedResolvedResource(uniqueResource.getResource(), rev.revision, rev.lastModified);
            }
            pattern = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + mrid.getRevision());
            ResolvedResource nonUnique = this.findResourceUsingPattern(mrid, pattern, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
            if (nonUnique != null) {
                return new LastModifiedResolvedResource(nonUnique.getResource(), rev.revision, rev.lastModified);
            }
        }
        return null;
    }

    private ResolvedResource findSnapshotDescriptor(DependencyDescriptor dd, ResolveData data, ModuleRevisionId mrid) {
        SnapshotRevision rev = this.findSnapshotRevision(mrid);
        Message.verbose((String)("[" + rev + "] " + mrid));
        if (rev != null) {
            Message.verbose((String)("[" + rev + "] " + mrid));
            String pattern = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + rev);
            ResolvedResource uniqueResource = this.findResourceUsingPattern(mrid, pattern, DefaultArtifact.newPomArtifact((ModuleRevisionId)mrid, (Date)data.getDate()), this.getRMDParser(dd, data), data.getDate());
            if (uniqueResource != null) {
                return new LastModifiedResolvedResource(uniqueResource.getResource(), rev.revision, rev.lastModified);
            }
            pattern = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + mrid.getRevision());
            ResolvedResource nonUnique = this.findResourceUsingPattern(mrid, pattern, DefaultArtifact.newPomArtifact((ModuleRevisionId)mrid, (Date)data.getDate()), this.getRMDParser(dd, data), data.getDate());
            if (nonUnique != null) {
                return new LastModifiedResolvedResource(nonUnique.getResource(), rev.revision, rev.lastModified);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnapshotRevision findSnapshotRevision(ModuleRevisionId mrid) {
        if (!this.isM2compatible()) {
            return null;
        }
        if (this.shouldUseMavenMetadata()) {
            InputStream metadataStream = null;
            try {
                String metadataLocation = IvyPatternHelper.substitute((String)(this.getRoot() + "[organisation]/[module]/[revision]/maven-metadata.xml"), (ModuleRevisionId)mrid);
                Resource metadata = this.getRepository().getResource(metadataLocation);
                if (metadata.exists()) {
                    metadataStream = metadata.openStream();
                    final StringBuilder timestamp = new StringBuilder();
                    final StringBuilder buildNumber = new StringBuilder();
                    final StringBuilder lastUpdated = new StringBuilder();
                    XMLHelper.parse((InputStream)metadataStream, null, (DefaultHandler)new ContextualSAXHandler(){

                        public void endElement(String uri, String localName, String qName) throws SAXException {
                            if ("metadata/versioning/snapshot/timestamp".equals(this.getContext())) {
                                timestamp.append(this.getText());
                            } else if ("metadata/versioning/snapshot/buildNumber".equals(this.getContext())) {
                                buildNumber.append(this.getText());
                            } else if ("metadata/versioning/lastUpdated".equals(this.getContext())) {
                                lastUpdated.append(this.getText());
                            }
                            super.endElement(uri, localName, qName);
                        }
                    }, null);
                    if (timestamp.length() > 0) {
                        String snapshotRevision = mrid.getRevision();
                        String baseRevision = snapshotRevision.substring(0, snapshotRevision.length() - "-SNAPSHOT".length());
                        String uniqueRevisionSuffix = timestamp + "-" + buildNumber;
                        SnapshotRevision snapshotRevision2 = new SnapshotRevision(baseRevision, uniqueRevisionSuffix, lastUpdated.toString());
                        return snapshotRevision2;
                    }
                } else {
                    Message.verbose((String)("\tmaven-metadata not available: " + metadata));
                }
            }
            catch (IOException e) {
                Message.verbose((String)("impossible to access maven metadata file, ignored: " + e.getMessage()));
            }
            catch (SAXException e) {
                Message.verbose((String)("impossible to parse maven metadata file, ignored: " + e.getMessage()));
            }
            catch (ParserConfigurationException e) {
                Message.verbose((String)("impossible to parse maven metadata file, ignored: " + e.getMessage()));
            }
            finally {
                if (metadataStream != null) {
                    try {
                        metadataStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return null;
    }

    private String getWholePattern() {
        return this.getRoot() + this.getPattern();
    }

    private boolean shouldUseMavenMetadata() {
        return this.isUseMavenMetadata() && this.isM2compatible() && this.getPattern().endsWith(M2_PATTERN);
    }

    private static class SnapshotRevision {
        public final String revision;
        public final String uniqueRevision;
        public final long lastModified;

        private SnapshotRevision(String revision, String uniqueRevisionSuffix, String lastModified) {
            this.revision = revision + "-SNAPSHOT";
            this.uniqueRevision = revision + "-" + uniqueRevisionSuffix;
            this.lastModified = this.calculateLastModified(lastModified);
        }

        private long calculateLastModified(String timestamp) {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                return format.parse(timestamp).getTime();
            }
            catch (ParseException e) {
                return -1L;
            }
        }

        public String toString() {
            return this.uniqueRevision;
        }
    }
}

