/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.build.logging.GrailsConsole;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.codehaus.groovy.grails.plugins.DefaultGrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.exceptions.PluginException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class ProfilingGrailsPluginManager
extends DefaultGrailsPluginManager {
    public ProfilingGrailsPluginManager(Class<?>[] plugins, GrailsApplication application) {
        super(plugins, application);
    }

    public ProfilingGrailsPluginManager(Resource[] pluginFiles, GrailsApplication application) {
        super(pluginFiles, application);
    }

    public ProfilingGrailsPluginManager(String resourcePath, GrailsApplication application) {
        super(resourcePath, application);
    }

    public ProfilingGrailsPluginManager(String[] pluginResources, GrailsApplication application) {
        super(pluginResources, application);
    }

    @Override
    public void loadPlugins() throws PluginException {
        GrailsConsole console = GrailsConsole.getInstance();
        long time = System.currentTimeMillis();
        console.addStatus("Loading plugins started");
        super.loadPlugins();
        console.addStatus("Loading plugins took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doDynamicMethods() {
        long time = System.currentTimeMillis();
        GrailsConsole console = GrailsConsole.getInstance();
        console.addStatus("doWithDynamicMethods started");
        this.checkInitialised();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (Class COMMON_CLASS : COMMON_CLASSES) {
            registry.removeMetaClass(COMMON_CLASS);
        }
        for (GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            try {
                long pluginTime = System.currentTimeMillis();
                console.addStatus("doWithDynamicMethods for plugin [" + plugin.getName() + "] started");
                plugin.doWithDynamicMethods(this.applicationContext);
                console.addStatus("doWithDynamicMethods for plugin [" + plugin.getName() + "] took " + (System.currentTimeMillis() - pluginTime));
            }
            catch (Throwable t) {
                console.error(t);
                console.error("Error configuring dynamic methods for plugin " + plugin + ": " + t.getMessage());
            }
        }
        console.addStatus("doWithDynamicMethods took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doRuntimeConfiguration(RuntimeSpringConfiguration springConfig) {
        long time = System.currentTimeMillis();
        GrailsConsole console = GrailsConsole.getInstance();
        console.addStatus("doWithSpring started");
        this.checkInitialised();
        for (GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            long pluginTime = System.currentTimeMillis();
            console.addStatus("doWithSpring for plugin [" + plugin.getName() + "] started");
            plugin.doWithRuntimeConfiguration(springConfig);
            console.addStatus("doWithSpring for plugin [" + plugin.getName() + "] took " + (System.currentTimeMillis() - pluginTime));
        }
        console.addStatus("doWithSpring took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doPostProcessing(ApplicationContext ctx) {
        long time = System.currentTimeMillis();
        GrailsConsole console = GrailsConsole.getInstance();
        console.addStatus("doWithApplicationContext started");
        this.checkInitialised();
        for (GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            long pluginTime = System.currentTimeMillis();
            console.addStatus("doWithApplicationContext for plugin [" + plugin.getName() + "] started");
            plugin.doWithApplicationContext(ctx);
            console.addStatus("doWithApplicationContext for plugin [" + plugin.getName() + "] took " + (System.currentTimeMillis() - pluginTime));
        }
        console.addStatus("doWithApplicationContext took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doArtefactConfiguration() {
        GrailsConsole console = GrailsConsole.getInstance();
        long time = System.currentTimeMillis();
        console.addStatus("doArtefactConfiguration started");
        super.doArtefactConfiguration();
        console.addStatus("doArtefactConfiguration took " + (System.currentTimeMillis() - time));
    }
}

