/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.HibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.codehaus.groovy.grails.orm.hibernate.support.ClosureEventTriggeringInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;

public class SavePersistentMethod
extends AbstractSavePersistentMethod {
    public static final String METHOD_SIGNATURE = "save";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^save$");

    public SavePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application, HibernateDatastore datastore) {
        super(METHOD_PATTERN, sessionFactory, classLoader, application, datastore);
    }

    public SavePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application, GrailsDomainClass domainClass, HibernateDatastore datastore) {
        super(METHOD_PATTERN, sessionFactory, classLoader, application, domainClass, datastore);
    }

    @Override
    protected Object performSave(final Object target, final boolean flush) {
        return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.saveOrUpdate(target);
                if (flush) {
                    SavePersistentMethod.this.flushSession(session);
                }
                return target;
            }
        });
    }

    @Override
    protected Object performInsert(final Object target, final boolean shouldFlush) {
        return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                try {
                    ClosureEventTriggeringInterceptor.markInsertActive();
                    session.save(target);
                    if (shouldFlush) {
                        SavePersistentMethod.this.flushSession(session);
                    }
                    Object object = target;
                    return object;
                }
                finally {
                    ClosureEventTriggeringInterceptor.resetInsertActive();
                }
            }
        });
    }

    protected void flushSession(Session session) throws HibernateException {
        try {
            session.flush();
        }
        catch (HibernateException e) {
            session.setFlushMode(FlushMode.MANUAL);
            throw e;
        }
    }
}

