/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import grails.validation.ValidationErrors;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.HibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractDynamicPersistentMethod;
import org.codehaus.groovy.grails.orm.hibernate.validation.AbstractPersistentConstraint;
import org.codehaus.groovy.grails.validation.CascadingValidator;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.event.ValidationEvent;
import org.hibernate.SessionFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

public class ValidatePersistentMethod
extends AbstractDynamicPersistentMethod {
    public static final String METHOD_SIGNATURE = "validate";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^validate$");
    public static final String ARGUMENT_DEEP_VALIDATE = "deepValidate";
    private static final String ARGUMENT_EVICT = "evict";
    private Validator validator;
    private HibernateDatastore datastore;

    public ValidatePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application) {
        this(sessionFactory, classLoader, application, null, null);
    }

    public ValidatePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application, Validator validator, HibernateDatastore datastore) {
        super(METHOD_PATTERN, sessionFactory, classLoader, application, datastore.getDefaultFlushMode());
        Assert.notNull((Object)application, (String)"Constructor argument 'application' cannot be null");
        this.validator = validator;
        this.datastore = datastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doInvokeInternal(Object target, Object[] arguments) {
        Errors errors = this.setupErrorsProperty(target);
        GrailsDomainClass domainClass = (GrailsDomainClass)this.application.getArtefact("Domain", target.getClass().getName());
        if (this.validator == null && domainClass != null) {
            this.validator = domainClass.getValidator();
        }
        if (this.validator == null) {
            return true;
        }
        Boolean valid = Boolean.TRUE;
        boolean evict = false;
        boolean deepValidate = true;
        HashSet validatedFields = null;
        List validatedFieldsList = null;
        if (arguments.length > 0) {
            if (arguments[0] instanceof Boolean) {
                evict = (Boolean)arguments[0];
            }
            if (arguments[0] instanceof Map) {
                Map argsMap = (Map)arguments[0];
                if (argsMap.containsKey(ARGUMENT_DEEP_VALIDATE)) {
                    deepValidate = GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_DEEP_VALIDATE, (Map)argsMap);
                }
                evict = GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_EVICT, (Map)argsMap);
            }
            if (arguments[0] instanceof List) {
                validatedFieldsList = (List)arguments[0];
                validatedFields = new HashSet(validatedFieldsList);
            }
        }
        this.fireEvent(target, validatedFieldsList);
        AbstractPersistentConstraint.sessionFactory.set(this.datastore.getSessionFactory());
        try {
            if (deepValidate && this.validator instanceof CascadingValidator) {
                ((CascadingValidator)this.validator).validate(target, errors, deepValidate);
            } else {
                this.validator.validate(target, errors);
            }
        }
        finally {
            AbstractPersistentConstraint.sessionFactory.remove();
        }
        int oldErrorCount = errors.getErrorCount();
        errors = this.filterErrors(errors, validatedFields, target);
        if (errors.hasErrors()) {
            valid = Boolean.FALSE;
            if (evict && this.getHibernateTemplate().contains(target)) {
                this.getHibernateTemplate().evict(target);
            }
        }
        if (errors.getErrorCount() != oldErrorCount) {
            MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
            metaClass.setProperty(target, "errors", (Object)errors);
        }
        return valid;
    }

    private void fireEvent(Object target, List<?> validatedFieldsList) {
        ValidationEvent event = new ValidationEvent((Datastore)this.datastore, target);
        event.setValidatedFields(validatedFieldsList);
        this.application.getMainContext().publishEvent((ApplicationEvent)event);
    }

    private Errors filterErrors(Errors errors, Set validatedFields, Object target) {
        if (validatedFields == null) {
            return errors;
        }
        ValidationErrors result = new ValidationErrors(target);
        List allErrors = errors.getAllErrors();
        for (Object allError : allErrors) {
            FieldError fieldError;
            ObjectError error = (ObjectError)allError;
            if (error instanceof FieldError && !validatedFields.contains((fieldError = (FieldError)error).getField())) continue;
            result.addError(error);
        }
        return result;
    }
}

