/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.orm.hibernate3.support.OpenSessionInViewInterceptor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.WebRequest;

public class GrailsOpenSessionInViewInterceptor
extends OpenSessionInViewInterceptor {
    private static final String IS_FLOW_REQUEST_ATTRIBUTE = "org.codehaus.groovy.grails.webflow.flow_request";

    public void preHandle(WebRequest request) throws DataAccessException {
        boolean isFlowRequest;
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        boolean bl = isFlowRequest = webRequest != null && webRequest.isFlowRequest();
        if (isFlowRequest) {
            webRequest.setAttribute(IS_FLOW_REQUEST_ATTRIBUTE, (Object)"true", 0);
        } else {
            super.preHandle(request);
            SessionFactory sessionFactory = this.getSessionFactory();
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
            if (sessionHolder != null) {
                Session session = sessionHolder.getSession();
                GrailsHibernateUtil.enableDynamicFilterEnablerIfPresent(sessionFactory, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHandle(WebRequest request, ModelMap model) throws DataAccessException {
        boolean isFlowRequest;
        boolean bl = isFlowRequest = request.getAttribute(IS_FLOW_REQUEST_ATTRIBUTE, 0) != null;
        if (isFlowRequest) {
            return;
        }
        try {
            super.postHandle(request, model);
        }
        finally {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory());
            if (sessionHolder != null) {
                Session session = sessionHolder.getSession();
                session.setFlushMode(FlushMode.MANUAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        try {
            boolean isWebRequest;
            boolean bl = isWebRequest = request.getAttribute(IS_FLOW_REQUEST_ATTRIBUTE, 0) != null;
            if (isWebRequest) {
                return;
            }
            request = (WebRequest)RequestContextHolder.currentRequestAttributes();
            if (!(request instanceof GrailsWebRequest)) {
                super.afterCompletion(request, ex);
                return;
            }
            GrailsWebRequest webRequest = (GrailsWebRequest)request;
            HttpServletResponse response = webRequest.getCurrentResponse();
            GrailsContentBufferingResponse contentBufferingResponse = this.getContentBufferingResponse(response);
            if (contentBufferingResponse == null) {
                super.afterCompletion(request, ex);
                return;
            }
            if (!contentBufferingResponse.isActive()) {
                super.afterCompletion(request, ex);
                return;
            }
            try {
                Session session = SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)false);
                if (session != null) {
                    session.disconnect();
                }
            }
            catch (IllegalStateException e) {
                super.afterCompletion(request, ex);
            }
        }
        finally {
            AbstractSavePersistentMethod.clearDisabledValidations();
        }
    }

    private GrailsContentBufferingResponse getContentBufferingResponse(HttpServletResponse response) {
        while (response instanceof HttpServletResponseWrapper) {
            if (response instanceof GrailsContentBufferingResponse) {
                return (GrailsContentBufferingResponse)response;
            }
            response = (HttpServletResponse)((HttpServletResponseWrapper)response).getResponse();
        }
        return null;
    }

    protected void flushIfNecessary(Session session, boolean existingTransaction) throws HibernateException {
        if (session != null && !FlushMode.isManualFlushMode((FlushMode)session.getFlushMode())) {
            super.flushIfNecessary(session, existingTransaction);
        }
    }
}

