/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.validation;

import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.lifecycle.ShutdownOperations;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTemplate;
import org.codehaus.groovy.grails.orm.hibernate.validation.PersistentConstraint;
import org.codehaus.groovy.grails.validation.AbstractConstraint;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.HibernateTemplate;

public abstract class AbstractPersistentConstraint
extends AbstractConstraint
implements PersistentConstraint {
    public static ThreadLocal<SessionFactory> sessionFactory = new ThreadLocal();
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public HibernateTemplate getHibernateTemplate() {
        SessionFactory sf = sessionFactory.get();
        if (sf == null) {
            sf = (SessionFactory)this.applicationContext.getBean("sessionFactory", SessionFactory.class);
        }
        GrailsApplication app = (GrailsApplication)this.applicationContext.getBean("grailsApplication", GrailsApplication.class);
        GrailsHibernateTemplate hibernateTemplate = new GrailsHibernateTemplate(sf, app, 0);
        hibernateTemplate.setAllowCreate(true);
        return hibernateTemplate;
    }

    public boolean supports(Class type) {
        return true;
    }

    public boolean isValid() {
        GrailsApplication grailsApplication;
        GrailsDomainClass domainClass;
        if (this.applicationContext.containsBean("sessionFactory") && (domainClass = (GrailsDomainClass)(grailsApplication = (GrailsApplication)this.applicationContext.getBean("grailsApplication", GrailsApplication.class)).getArtefact("Domain", this.constraintOwningClass.getName())) != null) {
            String mappingStrategy = domainClass.getMappingStrategy();
            return mappingStrategy.equals("GORM") || mappingStrategy.equals("hibernate");
        }
        return false;
    }

    static {
        ShutdownOperations.addOperation((Runnable)new Runnable(){

            @Override
            public void run() {
                sessionFactory.remove();
            }
        });
    }
}

