/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import grails.util.Environment;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.HibernateEventListeners;
import org.codehaus.groovy.grails.orm.hibernate.SessionFactoryHolder;
import org.codehaus.groovy.grails.orm.hibernate.SessionFactoryProxy;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsAnnotationConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.transaction.GrailsJdbcTransactionFactory;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.orm.hibernate4.HibernateExceptionTranslator;
import org.springframework.util.Assert;

public class ConfigurableLocalSessionFactoryBean
extends HibernateExceptionTranslator
implements FactoryBean<SessionFactory>,
ResourceLoaderAware,
InitializingBean,
DisposableBean,
ApplicationContextAware,
BeanClassLoaderAware {
    private DataSource dataSource;
    private Resource[] configLocations;
    private String[] mappingResources;
    private Resource[] mappingLocations;
    private Resource[] cacheableMappingLocations;
    private Resource[] mappingJarLocations;
    private Resource[] mappingDirectoryLocations;
    private Interceptor entityInterceptor;
    private NamingStrategy namingStrategy;
    private Properties hibernateProperties;
    private Class<?>[] annotatedClasses;
    private String[] annotatedPackages;
    private String[] packagesToScan;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private GrailsAnnotationConfiguration configuration;
    private SessionFactory sessionFactory;
    private static final Log LOG = LogFactory.getLog(ConfigurableLocalSessionFactoryBean.class);
    protected GrailsApplication grailsApplication;
    protected ClassLoader classLoader;
    protected Class<?> configClass;
    protected Class<?> currentSessionContextClass;
    protected Map<String, Object> eventListeners;
    protected HibernateEventListeners hibernateEventListeners;
    protected ApplicationContext applicationContext;
    protected boolean proxyIfReloadEnabled = true;
    protected String sessionFactoryBeanName = "sessionFactory";
    protected String dataSourceName = "DEFAULT";

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocations = new Resource[]{configLocation};
    }

    public void setConfigLocations(Resource[] configLocations) {
        this.configLocations = configLocations;
    }

    public Resource[] getConfigLocations() {
        return this.configLocations;
    }

    public void setMappingResources(String[] mappingResources) {
        this.mappingResources = mappingResources;
    }

    public String[] getMappingResources() {
        return this.mappingResources;
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public Resource[] getMappingLocations() {
        return this.mappingLocations;
    }

    public void setCacheableMappingLocations(Resource[] cacheableMappingLocations) {
        this.cacheableMappingLocations = cacheableMappingLocations;
    }

    public Resource[] getCacheableMappingLocations() {
        return this.cacheableMappingLocations;
    }

    public void setMappingJarLocations(Resource[] mappingJarLocations) {
        this.mappingJarLocations = mappingJarLocations;
    }

    public Resource[] getMappingJarLocations() {
        return this.mappingJarLocations;
    }

    public void setMappingDirectoryLocations(Resource[] mappingDirectoryLocations) {
        this.mappingDirectoryLocations = mappingDirectoryLocations;
    }

    public Resource[] getMappingDirectoryLocations() {
        return this.mappingDirectoryLocations;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() {
        return this.entityInterceptor;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public Properties getHibernateProperties() {
        if (this.hibernateProperties == null) {
            this.hibernateProperties = new Properties();
        }
        return this.hibernateProperties;
    }

    public void setAnnotatedClasses(Class<?>[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public Class<?>[] getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public void setAnnotatedPackages(String[] annotatedPackages) {
        this.annotatedPackages = annotatedPackages;
    }

    public String[] getAnnotatedPackages() {
        return this.annotatedPackages;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    public void setProxyIfReloadEnabled(boolean proxyIfReloadEnabled) {
        this.proxyIfReloadEnabled = proxyIfReloadEnabled;
    }

    public boolean isProxyIfReloadEnabled() {
        return this.proxyIfReloadEnabled;
    }

    public void setCurrentSessionContextClass(Class<?> currentSessionContextClass) {
        this.currentSessionContextClass = currentSessionContextClass;
    }

    public Class<?> getCurrentSessionContextClass() {
        return this.currentSessionContextClass;
    }

    public void setConfigClass(Class<?> configClass) {
        this.configClass = configClass;
    }

    public Class<?> getConfigClass() {
        return this.configClass;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    public void setHibernateEventListeners(HibernateEventListeners listeners) {
        this.hibernateEventListeners = listeners;
    }

    public HibernateEventListeners getHibernateEventListeners() {
        return this.hibernateEventListeners;
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setEventListeners(Map<String, Object> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public Map<String, Object> getEventListeners() {
        return this.eventListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.classLoader);
            this.buildSessionFactory();
        }
        finally {
            thread.setContextClassLoader(cl);
        }
    }

    protected void buildSessionFactory() throws Exception {
        this.configuration = this.newConfiguration();
        if (this.configLocations != null) {
            for (Resource resource : this.configLocations) {
                this.configuration.configure(resource.getURL());
            }
        }
        if (this.mappingResources != null) {
            for (String string : this.mappingResources) {
                ClassPathResource mr = new ClassPathResource(string.trim(), this.resourcePatternResolver.getClassLoader());
                this.configuration.addInputStream(mr.getInputStream());
            }
        }
        if (this.mappingLocations != null) {
            for (Resource resource : this.mappingLocations) {
                this.configuration.addInputStream(resource.getInputStream());
            }
        }
        if (this.cacheableMappingLocations != null) {
            for (Resource resource : this.cacheableMappingLocations) {
                this.configuration.addCacheableFile(resource.getFile());
            }
        }
        if (this.mappingJarLocations != null) {
            for (Resource resource : this.mappingJarLocations) {
                this.configuration.addJar(resource.getFile());
            }
        }
        if (this.mappingDirectoryLocations != null) {
            for (Resource resource : this.mappingDirectoryLocations) {
                File file = resource.getFile();
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("Mapping directory location [" + resource + "] does not denote a directory");
                }
                this.configuration.addDirectory(file);
            }
        }
        if (this.entityInterceptor != null) {
            this.configuration.setInterceptor(this.entityInterceptor);
        }
        if (this.namingStrategy != null) {
            this.configuration.setNamingStrategy(this.namingStrategy);
        }
        if (this.hibernateProperties != null) {
            this.configuration.addProperties(this.hibernateProperties);
        }
        if (this.annotatedClasses != null) {
            this.configuration.addAnnotatedClasses(this.annotatedClasses);
        }
        if (this.annotatedPackages != null) {
            this.configuration.addPackages(this.annotatedPackages);
        }
        if (this.packagesToScan != null) {
            this.configuration.scanPackages(this.packagesToScan);
        }
        if (this.eventListeners != null) {
            this.configuration.setEventListeners(this.eventListeners);
        }
        this.sessionFactory = this.doBuildSessionFactory();
        this.buildSessionFactoryProxy();
    }

    protected SessionFactory doBuildSessionFactory() {
        return this.configuration.buildSessionFactory();
    }

    protected void buildSessionFactoryProxy() {
        try {
            if (!Environment.getCurrent().isReloadEnabled() || !this.proxyIfReloadEnabled) {
                return;
            }
            SessionFactoryProxy sfp = new SessionFactoryProxy();
            String suffix = this.dataSourceName.equals("DEFAULT") ? "" : '_' + this.dataSourceName;
            SessionFactoryHolder sessionFactoryHolder = (SessionFactoryHolder)this.applicationContext.getBean("org.grails.internal.SESSION_FACTORY_HOLDER" + suffix, SessionFactoryHolder.class);
            sessionFactoryHolder.setSessionFactory(this.sessionFactory);
            sfp.setApplicationContext(this.applicationContext);
            sfp.setCurrentSessionContextClass(this.currentSessionContextClass);
            sfp.setTargetBean("org.grails.internal.SESSION_FACTORY_HOLDER" + suffix);
            sfp.afterPropertiesSet();
            this.sessionFactory = sfp;
        }
        catch (HibernateException e) {
            Throwable cause = e.getCause();
            if (this.isCacheConfigurationError(cause)) {
                LOG.error((Object)("There was an error configuring the Hibernate second level cache: " + this.getCauseMessage(e)));
                LOG.error((Object)"This is normally due to one of two reasons. Either you have incorrectly specified the cache provider class name in [DataSource.groovy] or you do not have the cache provider on your classpath (eg. runtime (\"net.sf.ehcache:ehcache:2.4.8\"))");
                if (Environment.isDevelopmentMode()) {
                    System.exit(1);
                }
            }
            throw e;
        }
    }

    public final Configuration getConfiguration() {
        Assert.state((this.configuration != null ? 1 : 0) != 0, (String)"Configuration not initialized yet");
        return this.configuration;
    }

    public SessionFactory getObject() {
        return this.sessionFactory;
    }

    public Class<?> getObjectType() {
        return this.sessionFactory == null ? SessionFactory.class : this.sessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.grailsApplication.isWarDeployed()) {
            MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
            Map classMetaData = this.sessionFactory.getAllClassMetadata();
            for (Object o : classMetaData.values()) {
                registry.removeMetaClass(((ClassMetadata)o).getMappedClass());
            }
        }
        try {
            this.sessionFactory.close();
        }
        catch (HibernateException e) {
            if (e.getCause() instanceof NameNotFoundException) {
                LOG.debug((Object)e.getCause().getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    protected GrailsAnnotationConfiguration newConfiguration() throws Exception {
        if (this.configClass == null) {
            this.configClass = GrailsAnnotationConfiguration.class;
        }
        GrailsAnnotationConfiguration config = (GrailsAnnotationConfiguration)((Object)BeanUtils.instantiateClass(this.configClass));
        config.setApplicationContext(this.applicationContext);
        config.setGrailsApplication(this.grailsApplication);
        config.setSessionFactoryBeanName(this.sessionFactoryBeanName);
        config.setDataSourceName(this.dataSourceName);
        config.setHibernateEventListeners(this.hibernateEventListeners);
        if (this.currentSessionContextClass != null) {
            config.setProperty("hibernate.current_session_context_class", this.currentSessionContextClass.getName());
        }
        this.configureGrailsJdbcTransactionFactory(config);
        config.afterPropertiesSet();
        return config;
    }

    protected void configureGrailsJdbcTransactionFactory(Configuration config) {
        String configuredStrategy = config.getProperty("hibernate.transaction.factory_class");
        if (configuredStrategy == null || "jdbc".equals(configuredStrategy)) {
            config.setProperty("hibernate.transaction.factory_class", GrailsJdbcTransactionFactory.class.getName());
        }
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.classLoader = beanClassLoader;
    }

    protected String getCauseMessage(HibernateException e) {
        Throwable cause = e.getCause();
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        return cause.getMessage();
    }

    protected boolean isCacheConfigurationError(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        return cause != null && cause instanceof CacheException;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

