/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.IHibernateTemplate;
import org.codehaus.groovy.grails.orm.hibernate.SessionFactoryProxy;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.internal.SessionFactoryImpl;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class GrailsHibernateTemplate
implements IHibernateTemplate {
    private static final Log LOG = LogFactory.getLog(GrailsHibernateTemplate.class);
    private boolean osivReadOnly;
    private boolean passReadOnlyToHibernate = false;
    protected boolean exposeNativeSession = true;
    protected boolean cacheQueries = false;
    protected boolean allowCreate = true;
    protected boolean checkWriteOperations = true;
    protected SessionFactory sessionFactory;
    protected SQLExceptionTranslator jdbcExceptionTranslator;
    protected int flushMode = 1;
    private boolean applyFlushModeOnlyToNonExistingTransactions = false;
    public static final int FLUSH_NEVER = 0;
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EAGER = 2;
    public static final int FLUSH_COMMIT = 3;
    public static final int FLUSH_ALWAYS = 4;

    protected GrailsHibernateTemplate() {
    }

    public GrailsHibernateTemplate(SessionFactory sessionFactory) {
        ConnectionProvider connectionProvider;
        Assert.notNull((Object)sessionFactory, (String)"Property 'sessionFactory' is required");
        this.sessionFactory = sessionFactory;
        if (sessionFactory instanceof SessionFactoryProxy) {
            sessionFactory = ((SessionFactoryProxy)sessionFactory).getCurrentSessionFactory();
        }
        if ((connectionProvider = (ConnectionProvider)((SessionFactoryImpl)sessionFactory).getServiceRegistry().getService(ConnectionProvider.class)) instanceof DatasourceConnectionProviderImpl) {
            this.jdbcExceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(((DatasourceConnectionProviderImpl)connectionProvider).getDataSource());
        } else {
            SQLErrorCodeSQLExceptionTranslator sqlErrorCodeSQLExceptionTranslator = new SQLErrorCodeSQLExceptionTranslator();
            sqlErrorCodeSQLExceptionTranslator.setDatabaseProductName("H2");
            this.jdbcExceptionTranslator = sqlErrorCodeSQLExceptionTranslator;
        }
    }

    public GrailsHibernateTemplate(SessionFactory sessionFactory, GrailsApplication application) {
        this(sessionFactory, application, 1);
    }

    public GrailsHibernateTemplate(SessionFactory sessionFactory, GrailsApplication application, int defaultFlushMode) {
        this(sessionFactory);
        if (application != null) {
            this.cacheQueries = GrailsHibernateUtil.isCacheQueriesByDefault(application);
            this.osivReadOnly = GrailsHibernateUtil.isOsivReadonly(application);
            this.passReadOnlyToHibernate = GrailsHibernateUtil.isPassReadOnlyToHibernate(application);
        }
        this.flushMode = defaultFlushMode;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void applySettings(Query query) {
        if (this.exposeNativeSession) {
            this.prepareQuery(query);
        }
    }

    public void applySettings(Criteria criteria) {
        if (this.exposeNativeSession) {
            this.prepareCriteria(criteria);
        }
    }

    public void setCacheQueries(boolean cacheQueries) {
        this.cacheQueries = cacheQueries;
    }

    public boolean isCacheQueries() {
        return this.cacheQueries;
    }

    public <T> T execute(HibernateCallback<T> action) throws DataAccessException {
        return this.doExecute(action, false);
    }

    public List<?> executeFind(HibernateCallback<?> action) throws DataAccessException {
        Object result = this.doExecute(action, false);
        if (result != null && !(result instanceof List)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from HibernateCallback isn't a List: [" + result + "]");
        }
        return (List)result;
    }

    protected boolean shouldPassReadOnlyToHibernate() {
        if ((this.passReadOnlyToHibernate || this.osivReadOnly) && TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                return this.passReadOnlyToHibernate && TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            }
            return this.osivReadOnly;
        }
        return false;
    }

    public boolean isOsivReadOnly() {
        return this.osivReadOnly;
    }

    public void setOsivReadOnly(boolean osivReadOnly) {
        this.osivReadOnly = osivReadOnly;
    }

    protected <T> T doExecute(HibernateCallback<T> action, boolean enforceNativeSession) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Session session = this.getSession();
        boolean existingTransaction = this.isSessionTransactional(session);
        if (existingTransaction) {
            LOG.debug((Object)"Found thread-bound Session for HibernateTemplate");
        }
        FlushMode previousFlushMode = null;
        try {
            previousFlushMode = this.applyFlushMode(session, existingTransaction);
            if (this.shouldPassReadOnlyToHibernate()) {
                session.setDefaultReadOnly(true);
            }
            Session sessionToExpose = enforceNativeSession || this.exposeNativeSession ? session : this.createSessionProxy(session);
            T result = action.doInHibernate(sessionToExpose);
            this.flushIfNecessary(session, existingTransaction);
            T t = result;
            return t;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        catch (SQLException ex) {
            throw this.jdbcExceptionTranslator.translate("Hibernate-related JDBC operation", null, ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (existingTransaction) {
                LOG.debug((Object)"Not closing pre-bound Hibernate Session after HibernateTemplate");
                if (previousFlushMode != null) {
                    session.setFlushMode(previousFlushMode);
                }
            } else {
                SessionFactoryUtils.closeSession((Session)session);
            }
        }
    }

    protected boolean isSessionTransactional(Session session) {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        return sessionHolder != null && sessionHolder.getSession() == session;
    }

    protected Session getSession() {
        try {
            return this.sessionFactory.getCurrentSession();
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not obtain current Hibernate Session", (Throwable)ex);
        }
    }

    protected Session createSessionProxy(Session session) {
        Class[] sessionIfcs = null;
        Class<Session> mainIfc = Session.class;
        sessionIfcs = session instanceof EventSource ? new Class[]{mainIfc, EventSource.class} : (session instanceof SessionImplementor ? new Class[]{mainIfc, SessionImplementor.class} : new Class[]{mainIfc});
        return (Session)Proxy.newProxyInstance(session.getClass().getClassLoader(), sessionIfcs, (InvocationHandler)new CloseSuppressingInvocationHandler(session));
    }

    public <T> T get(final Class<T> entityClass, final Serializable id) throws DataAccessException {
        return this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException {
                return session.get(entityClass, id);
            }
        }, true);
    }

    public <T> T get(Class<T> entityClass, Serializable id, LockMode mode) {
        return this.lock(entityClass, id, mode);
    }

    public void delete(final Object entity) throws DataAccessException {
        this.doExecute(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.delete(entity);
                return null;
            }
        }, true);
    }

    public void flush(Object entity) throws DataAccessException {
        this.doExecute(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.flush();
                return null;
            }
        }, true);
    }

    public <T> T load(final Class<T> entityClass, final Serializable id) throws DataAccessException {
        return this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException {
                return session.load(entityClass, id);
            }
        }, true);
    }

    public <T> T lock(final Class<T> entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException {
                return session.get(entityClass, id, new LockOptions(lockMode));
            }
        }, true);
    }

    public <T> List<T> loadAll(final Class<T> entityClass) throws DataAccessException {
        return (List)this.doExecute(new HibernateCallback<List<T>>(){

            @Override
            public List<T> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(entityClass);
                criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
                GrailsHibernateTemplate.this.prepareCriteria(criteria);
                return criteria.list();
            }
        }, true);
    }

    public boolean contains(final Object entity) throws DataAccessException {
        return this.doExecute(new HibernateCallback<Boolean>(){

            @Override
            public Boolean doInHibernate(Session session) {
                return session.contains(entity);
            }
        }, true);
    }

    public void evict(final Object entity) throws DataAccessException {
        this.doExecute(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.evict(entity);
                return null;
            }
        }, true);
    }

    public void lock(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.doExecute(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.buildLockRequest(new LockOptions(lockMode)).lock(entity);
                return null;
            }
        }, true);
    }

    public void refresh(Object entity) throws DataAccessException {
        this.refresh(entity, null);
    }

    public void refresh(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.doExecute(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode == null) {
                    session.refresh(entity);
                } else {
                    session.refresh(entity, new LockOptions(lockMode));
                }
                return null;
            }
        }, true);
    }

    public void setExposeNativeSession(boolean exposeNativeSession) {
        this.exposeNativeSession = exposeNativeSession;
    }

    public boolean isExposeNativeSession() {
        return this.exposeNativeSession;
    }

    protected void prepareQuery(Query query) {
        SessionHolder sessionHolder;
        if (this.cacheQueries) {
            query.setCacheable(true);
        }
        if (this.shouldPassReadOnlyToHibernate()) {
            query.setReadOnly(true);
        }
        if ((sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory)) != null && sessionHolder.hasTimeout()) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    protected void prepareCriteria(Criteria criteria) {
        SessionHolder sessionHolder;
        if (this.cacheQueries) {
            criteria.setCacheable(true);
        }
        if (this.shouldPassReadOnlyToHibernate()) {
            criteria.setReadOnly(true);
        }
        if ((sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory)) != null && sessionHolder.hasTimeout()) {
            criteria.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public void setFlushMode(int flushMode) {
        this.flushMode = flushMode;
    }

    public int getFlushMode() {
        return this.flushMode;
    }

    protected FlushMode applyFlushMode(Session session, boolean existingTransaction) {
        if (this.isApplyFlushModeOnlyToNonExistingTransactions() && existingTransaction) {
            return null;
        }
        if (this.getFlushMode() == 0) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getFlushMode();
                if (!previousFlushMode.lessThan(FlushMode.COMMIT)) {
                    session.setFlushMode(FlushMode.MANUAL);
                    return previousFlushMode;
                }
            } else {
                session.setFlushMode(FlushMode.MANUAL);
            }
        } else if (this.getFlushMode() == 2) {
            FlushMode previousFlushMode;
            if (existingTransaction && !(previousFlushMode = session.getFlushMode()).equals((Object)FlushMode.AUTO)) {
                session.setFlushMode(FlushMode.AUTO);
                return previousFlushMode;
            }
        } else if (this.getFlushMode() == 3) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getFlushMode();
                if (previousFlushMode.equals((Object)FlushMode.AUTO) || previousFlushMode.equals((Object)FlushMode.ALWAYS)) {
                    session.setFlushMode(FlushMode.COMMIT);
                    return previousFlushMode;
                }
            } else {
                session.setFlushMode(FlushMode.COMMIT);
            }
        } else if (this.getFlushMode() == 4) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getFlushMode();
                if (!previousFlushMode.equals((Object)FlushMode.ALWAYS)) {
                    session.setFlushMode(FlushMode.ALWAYS);
                    return previousFlushMode;
                }
            } else {
                session.setFlushMode(FlushMode.ALWAYS);
            }
        }
        return null;
    }

    protected void flushIfNecessary(Session session, boolean existingTransaction) throws HibernateException {
        if (this.getFlushMode() == 2 || !existingTransaction && this.getFlushMode() != 0) {
            LOG.debug((Object)"Eagerly flushing Hibernate session");
            session.flush();
        }
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return this.convertJdbcAccessException((JDBCException)ex, this.jdbcExceptionTranslator);
        }
        if (GenericJDBCException.class.equals(((Object)((Object)ex)).getClass())) {
            return this.convertJdbcAccessException((JDBCException)((GenericJDBCException)ex), this.jdbcExceptionTranslator);
        }
        return SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
    }

    protected DataAccessException convertJdbcAccessException(JDBCException ex, SQLExceptionTranslator translator) {
        String msg = ex.getMessage();
        String sql = ex.getSQL();
        SQLException sqlException = ex.getSQLException();
        return translator.translate("Hibernate operation: " + msg, sql, sqlException);
    }

    public Serializable save(Object o) {
        return this.sessionFactory.getCurrentSession().save(o);
    }

    public void flush() {
        this.sessionFactory.getCurrentSession().flush();
    }

    public void clear() {
        this.sessionFactory.getCurrentSession().clear();
    }

    public void deleteAll(final Collection<?> objects) {
        this.execute(new HibernateCallback<Void>(){

            @Override
            public Void doInHibernate(Session session) throws HibernateException {
                for (Object entity : GrailsHibernateTemplate.this.getIterableAsCollection(objects)) {
                    session.delete(entity);
                }
                return null;
            }
        });
    }

    protected Collection getIterableAsCollection(Iterable objects) {
        ArrayList list;
        if (objects instanceof Collection) {
            list = (ArrayList)objects;
        } else {
            list = new ArrayList();
            for (Object object : objects) {
                list.add(object);
            }
        }
        return list;
    }

    public boolean isApplyFlushModeOnlyToNonExistingTransactions() {
        return this.applyFlushModeOnlyToNonExistingTransactions;
    }

    public void setApplyFlushModeOnlyToNonExistingTransactions(boolean applyFlushModeOnlyToNonExistingTransactions) {
        this.applyFlushModeOnlyToNonExistingTransactions = applyFlushModeOnlyToNonExistingTransactions;
    }

    protected class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        protected final Session target;

        protected CloseSuppressingInvocationHandler(Session target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Query) {
                    GrailsHibernateTemplate.this.prepareQuery((Query)retVal);
                }
                if (retVal instanceof Criteria) {
                    GrailsHibernateTemplate.this.prepareCriteria((Criteria)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    public static interface HibernateCallback<T> {
        public T doInHibernate(Session var1) throws HibernateException, SQLException;
    }
}

