/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import grails.util.CollectionUtils;
import grails.util.Holders;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.DefaultGrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.codehaus.groovy.grails.orm.hibernate.proxy.GroovyAwareJavassistProxyFactory;
import org.codehaus.groovy.grails.orm.hibernate.proxy.HibernateProxyHandler;
import org.codehaus.groovy.grails.orm.hibernate.query.HibernateQueryConstants;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.convert.ConversionService;

public class GrailsHibernateUtil
implements HibernateQueryConstants {
    protected static final Log LOG = LogFactory.getLog(GrailsHibernateUtil.class);
    private static final String DYNAMIC_FILTER_ENABLER = "dynamicFilterEnabler";
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static HibernateProxyHandler proxyHandler = new HibernateProxyHandler();
    private static GrailsDomainBinder binder = new GrailsDomainBinder();

    public static void enableDynamicFilterEnablerIfPresent(SessionFactory sessionFactory, Session session) {
        Set definedFilterNames;
        if (sessionFactory != null && session != null && (definedFilterNames = sessionFactory.getDefinedFilterNames()) != null && definedFilterNames.contains(DYNAMIC_FILTER_ENABLER)) {
            session.enableFilter(DYNAMIC_FILTER_ENABLER);
        }
    }

    public static void configureHibernateDomainClasses(SessionFactory sessionFactory, String sessionFactoryName, GrailsApplication application) {
        HashMap<String, GrailsDomainClass> hibernateDomainClassMap = new HashMap<String, GrailsDomainClass>();
        for (Object o : sessionFactory.getAllClassMetadata().values()) {
            ClassMetadata classMetadata = (ClassMetadata)o;
            GrailsHibernateUtil.configureDomainClass(sessionFactory, sessionFactoryName, application, classMetadata, classMetadata.getMappedClass(), hibernateDomainClassMap);
        }
        GrailsHibernateUtil.configureInheritanceMappings(hibernateDomainClassMap);
    }

    public static void configureInheritanceMappings(Map hibernateDomainClassMap) {
        block0: for (Object o : hibernateDomainClassMap.values()) {
            GrailsDomainClass baseClass = (GrailsDomainClass)o;
            if (baseClass.isRoot()) continue;
            Class superClass = baseClass.getClazz().getSuperclass();
            while (!superClass.equals(Object.class) && !superClass.equals(GroovyObject.class)) {
                GrailsDomainClass gdc = (GrailsDomainClass)hibernateDomainClassMap.get(superClass.getName());
                if (gdc == null || gdc.getSubClasses() == null) {
                    LOG.debug((Object)"did not find superclass names when mapping inheritance....");
                    continue block0;
                }
                gdc.getSubClasses().add(baseClass);
                superClass = superClass.getSuperclass();
            }
        }
    }

    private static void configureDomainClass(SessionFactory sessionFactory, String sessionFactoryName, GrailsApplication application, ClassMetadata cmd, Class<?> persistentClass, Map<String, GrailsDomainClass> hibernateDomainClassMap) {
        LOG.trace((Object)("Configuring domain class [" + persistentClass + "]"));
        GrailsDomainClass dc = (GrailsDomainClass)application.getArtefact("Domain", persistentClass.getName());
        if (dc == null && sessionFactory.getClassMetadata(persistentClass) != null) {
            GrailsHibernateDomainClass ghdc = new GrailsHibernateDomainClass(persistentClass, sessionFactory, sessionFactoryName, application, cmd);
            hibernateDomainClassMap.put(persistentClass.getName(), (GrailsDomainClass)ghdc);
            dc = (GrailsDomainClass)application.addArtefact("Domain", (GrailsClass)ghdc);
        }
    }

    public static void populateArgumentsForCriteria(GrailsApplication grailsApplication, Class<?> targetClass, Criteria c, Map argMap, ConversionService conversionService) {
        GrailsHibernateUtil.populateArgumentsForCriteria(grailsApplication, targetClass, c, argMap, conversionService, true);
    }

    public static void populateArgumentsForCriteria(GrailsApplication grailsApplication, Class<?> targetClass, Criteria c, Map argMap, ConversionService conversionService, boolean useDefaultMapping) {
        block20: {
            Mapping m;
            block19: {
                int offset;
                Integer maxParam = null;
                Integer offsetParam = null;
                if (argMap.containsKey("max")) {
                    maxParam = (Integer)conversionService.convert(argMap.get("max"), Integer.class);
                }
                if (argMap.containsKey("offset")) {
                    offsetParam = (Integer)conversionService.convert(argMap.get("offset"), Integer.class);
                }
                if (argMap.containsKey("fetchSize")) {
                    c.setFetchSize(((Integer)conversionService.convert(argMap.get("fetchSize"), Integer.class)).intValue());
                }
                if (argMap.containsKey("timeout")) {
                    c.setTimeout(((Integer)conversionService.convert(argMap.get("timeout"), Integer.class)).intValue());
                }
                if (argMap.containsKey("flushMode")) {
                    c.setFlushMode(GrailsHibernateUtil.convertFlushMode(argMap.get("flushMode")));
                }
                if (argMap.containsKey("readOnly")) {
                    c.setReadOnly(GrailsClassUtils.getBooleanFromMap((String)"readOnly", (Map)argMap));
                }
                String orderParam = (String)argMap.get("order");
                Object fetchObj = argMap.get("fetch");
                if (fetchObj instanceof Map) {
                    Map fetch = (Map)fetchObj;
                    for (Object o : fetch.keySet()) {
                        String associationName = (String)o;
                        c.setFetchMode(associationName, GrailsHibernateUtil.getFetchMode(fetch.get(associationName)));
                    }
                }
                int max = maxParam == null ? -1 : maxParam;
                int n = offset = offsetParam == null ? -1 : offsetParam;
                if (max > -1) {
                    c.setMaxResults(max);
                }
                if (offset > -1) {
                    c.setFirstResult(offset);
                }
                if (GrailsClassUtils.getBooleanFromMap((String)"lock", (Map)argMap)) {
                    c.setLockMode(LockMode.PESSIMISTIC_WRITE);
                    c.setCacheable(false);
                } else if (argMap.containsKey("cache")) {
                    c.setCacheable(GrailsClassUtils.getBooleanFromMap((String)"cache", (Map)argMap));
                } else {
                    GrailsHibernateUtil.cacheCriteriaByMapping(targetClass, c);
                }
                Object sortObj = argMap.get("sort");
                if (sortObj == null) break block19;
                boolean ignoreCase = true;
                Object caseArg = argMap.get("ignoreCase");
                if (caseArg instanceof Boolean) {
                    ignoreCase = (Boolean)caseArg;
                }
                if (sortObj instanceof Map) {
                    Map sortMap = (Map)sortObj;
                    for (Object sort : sortMap.keySet()) {
                        String order = "desc".equalsIgnoreCase((String)sortMap.get(sort)) ? "desc" : "asc";
                        GrailsHibernateUtil.addOrderPossiblyNested(grailsApplication, c, targetClass, (String)sort, order, ignoreCase);
                    }
                } else {
                    String sort = (String)sortObj;
                    String order = "desc".equalsIgnoreCase(orderParam) ? "desc" : "asc";
                    GrailsHibernateUtil.addOrderPossiblyNested(grailsApplication, c, targetClass, sort, order, ignoreCase);
                }
                break block20;
            }
            if (!useDefaultMapping || (m = binder.getMapping(targetClass)) == null) break block20;
            Map sortMap = m.getSort().getNamesAndDirections();
            for (Object sort : sortMap.keySet()) {
                String order = "desc".equalsIgnoreCase((String)sortMap.get(sort)) ? "desc" : "asc";
                GrailsHibernateUtil.addOrderPossiblyNested(grailsApplication, c, targetClass, (String)sort, order, true);
            }
        }
    }

    @Deprecated
    public static void populateArgumentsForCriteria(Class<?> targetClass, Criteria c, Map argMap, ConversionService conversionService) {
        GrailsHibernateUtil.populateArgumentsForCriteria(null, targetClass, c, argMap, conversionService);
    }

    public static void populateArgumentsForCriteria(Criteria c, Map argMap, ConversionService conversionService) {
        GrailsHibernateUtil.populateArgumentsForCriteria(null, null, c, argMap, conversionService);
    }

    private static FlushMode convertFlushMode(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof FlushMode) {
            return (FlushMode)object;
        }
        return FlushMode.valueOf((String)String.valueOf(object));
    }

    private static void addOrderPossiblyNested(GrailsApplication grailsApplication, Criteria c, Class<?> targetClass, String sort, String order, boolean ignoreCase) {
        int firstDotPos = sort.indexOf(".");
        if (firstDotPos == -1) {
            GrailsHibernateUtil.addOrder(c, sort, order, ignoreCase);
        } else {
            String sortHead = sort.substring(0, firstDotPos);
            String sortTail = sort.substring(firstDotPos + 1);
            GrailsDomainClassProperty property = GrailsHibernateUtil.getGrailsDomainClassProperty(grailsApplication, targetClass, sortHead);
            if (property != null) {
                if (property.isEmbedded()) {
                    GrailsHibernateUtil.addOrder(c, sort, order, ignoreCase);
                } else {
                    Criteria subCriteria = c.createCriteria(sortHead);
                    Class propertyTargetClass = property.getReferencedDomainClass().getClazz();
                    GrailsHibernateUtil.cacheCriteriaByMapping(grailsApplication, propertyTargetClass, subCriteria);
                    GrailsHibernateUtil.addOrderPossiblyNested(grailsApplication, subCriteria, propertyTargetClass, sortTail, order, ignoreCase);
                }
            }
        }
    }

    private static void addOrder(Criteria c, String sort, String order, boolean ignoreCase) {
        if ("desc".equals(order)) {
            c.addOrder(ignoreCase ? Order.desc((String)sort).ignoreCase() : Order.desc((String)sort));
        } else {
            c.addOrder(ignoreCase ? Order.asc((String)sort).ignoreCase() : Order.asc((String)sort));
        }
    }

    private static GrailsDomainClassProperty getGrailsDomainClassProperty(GrailsApplication grailsApplication, Class<?> targetClass, String propertyName) {
        GrailsClass grailsClass;
        GrailsClass grailsClass2 = grailsClass = grailsApplication != null ? grailsApplication.getArtefact("Domain", targetClass.getName()) : null;
        if (!(grailsClass instanceof GrailsDomainClass)) {
            throw new IllegalArgumentException("Unexpected: class is not a domain class:" + targetClass.getName());
        }
        GrailsDomainClass domainClass = (GrailsDomainClass)grailsClass;
        return domainClass.getPropertyByName(propertyName);
    }

    public static void cacheCriteriaByMapping(Class<?> targetClass, Criteria criteria) {
        Mapping m = binder.getMapping(targetClass);
        if (m != null && m.getCache() != null && m.getCache().getEnabled()) {
            criteria.setCacheable(true);
        }
    }

    public static void cacheCriteriaByMapping(GrailsApplication grailsApplication, Class<?> targetClass, Criteria criteria) {
        GrailsHibernateUtil.cacheCriteriaByMapping(targetClass, criteria);
    }

    public static FetchMode getFetchMode(Object object) {
        String name;
        String string = name = object != null ? object.toString() : "default";
        if (name.equalsIgnoreCase(FetchMode.JOIN.toString()) || name.equalsIgnoreCase("eager")) {
            return FetchMode.JOIN;
        }
        if (name.equalsIgnoreCase(FetchMode.SELECT.toString()) || name.equalsIgnoreCase("lazy")) {
            return FetchMode.SELECT;
        }
        return FetchMode.DEFAULT;
    }

    public static void setObjectToReadyOnly(Object target, SessionFactory sessionFactory) {
        Session session = sessionFactory.getCurrentSession();
        if (GrailsHibernateUtil.canModifyReadWriteState(session, target)) {
            if (target instanceof HibernateProxy) {
                target = ((HibernateProxy)target).getHibernateLazyInitializer().getImplementation();
            }
            session.setReadOnly(target, true);
            session.setFlushMode(FlushMode.MANUAL);
        }
    }

    private static boolean canModifyReadWriteState(Session session, Object target) {
        return session.contains(target) && Hibernate.isInitialized((Object)target);
    }

    public static void setObjectToReadWrite(Object target, SessionFactory sessionFactory) {
        Session session = sessionFactory.getCurrentSession();
        if (!GrailsHibernateUtil.canModifyReadWriteState(session, target)) {
            return;
        }
        SessionImplementor sessionImpl = (SessionImplementor)session;
        EntityEntry ee = sessionImpl.getPersistenceContext().getEntry(target);
        if (ee == null || ee.getStatus() != Status.READ_ONLY) {
            return;
        }
        Object actualTarget = target;
        if (target instanceof HibernateProxy) {
            actualTarget = ((HibernateProxy)target).getHibernateLazyInitializer().getImplementation();
        }
        session.setReadOnly(actualTarget, false);
        session.setFlushMode(FlushMode.AUTO);
        GrailsHibernateUtil.incrementVersion(target);
    }

    public static void incrementVersion(Object target) {
        Object version;
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        if (metaClass.hasProperty(target, "version") != null && (version = metaClass.getProperty(target, "version")) instanceof Long) {
            Long newVersion = (Long)version + 1L;
            metaClass.setProperty(target, "version", (Object)newVersion);
        }
    }

    public static void ensureCorrectGroovyMetaClass(Object target, Class<?> persistentClass) {
        GroovyObject go;
        if (target instanceof GroovyObject && !(go = (GroovyObject)target).getMetaClass().getTheClass().equals(persistentClass)) {
            go.setMetaClass(GroovySystem.getMetaClassRegistry().getMetaClass(persistentClass));
        }
    }

    public static Object unwrapProxy(HibernateProxy proxy) {
        return proxyHandler.unwrapProxy(proxy);
    }

    public static HibernateProxy getAssociationProxy(Object obj, String associationName) {
        return proxyHandler.getAssociationProxy(obj, associationName);
    }

    public static boolean isInitialized(Object obj, String associationName) {
        return proxyHandler.isInitialized(obj, associationName);
    }

    public static boolean isCacheQueriesByDefault() {
        return GrailsHibernateUtil.isCacheQueriesByDefault(Holders.getGrailsApplication());
    }

    public static boolean isCacheQueriesByDefault(GrailsApplication grailsApplication) {
        return GrailsHibernateUtil.isConfigTrue(grailsApplication, "grails.hibernate.cache.queries");
    }

    public static boolean isOsivReadonly(GrailsApplication grailsApplication) {
        return GrailsHibernateUtil.isConfigTrue(grailsApplication, "grails.hibernate.osiv.readonly");
    }

    public static boolean isPassReadOnlyToHibernate(GrailsApplication grailsApplication) {
        return GrailsHibernateUtil.isConfigTrue(grailsApplication, "grails.hibernate.pass.readonly");
    }

    public static boolean isConfigTrue(GrailsApplication application, String propertyName) {
        return application != null && application.getFlatConfig() != null && DefaultTypeTransformation.castToBoolean(application.getFlatConfig().get(propertyName)) || Boolean.getBoolean(propertyName);
    }

    public static GroovyAwareJavassistProxyFactory buildProxyFactory(PersistentClass persistentClass) {
        GroovyAwareJavassistProxyFactory proxyFactory = new GroovyAwareJavassistProxyFactory();
        Set proxyInterfaces = CollectionUtils.newSet((Object[])new Class[]{HibernateProxy.class});
        Class javaClass = persistentClass.getMappedClass();
        Property identifierProperty = persistentClass.getIdentifierProperty();
        Method idGetterMethod = identifierProperty != null ? identifierProperty.getGetter(javaClass).getMethod() : null;
        Method idSetterMethod = identifierProperty != null ? identifierProperty.getSetter(javaClass).getMethod() : null;
        Type identifierType = persistentClass.hasEmbeddedIdentifier() ? persistentClass.getIdentifier().getType() : null;
        try {
            proxyFactory.postInstantiate(persistentClass.getEntityName(), javaClass, proxyInterfaces, idGetterMethod, idSetterMethod, identifierType instanceof CompositeType ? (CompositeType)identifierType : null);
        }
        catch (HibernateException e) {
            LOG.warn((Object)("Cannot instantiate proxy factory: " + e.getMessage()));
            return null;
        }
        return proxyFactory;
    }

    public static Object unwrapIfProxy(Object instance) {
        return proxyHandler.unwrapIfProxy(instance);
    }

    public static boolean usesDatasource(GrailsDomainClass domainClass, String dataSourceName) {
        if (domainClass instanceof GrailsHibernateDomainClass) {
            GrailsHibernateDomainClass hibernateDomainClass = (GrailsHibernateDomainClass)domainClass;
            String sessionFactoryName = hibernateDomainClass.getSessionFactoryName();
            if (dataSourceName.equals("DEFAULT")) {
                return "sessionFactory".equals(sessionFactoryName);
            }
            return sessionFactoryName.endsWith("_" + dataSourceName);
        }
        List<String> names = GrailsHibernateUtil.getDatasourceNames(domainClass);
        return names.contains(dataSourceName) || names.contains("ALL");
    }

    public static String getDefaultDataSource(GrailsDomainClass domainClass) {
        if (domainClass instanceof GrailsHibernateDomainClass) {
            GrailsHibernateDomainClass hibernateDomainClass = (GrailsHibernateDomainClass)domainClass;
            String sessionFactoryName = hibernateDomainClass.getSessionFactoryName();
            if ("sessionFactory".equals(sessionFactoryName)) {
                return "DEFAULT";
            }
            return sessionFactoryName.substring("sessionFactory_".length());
        }
        List<String> names = GrailsHibernateUtil.getDatasourceNames(domainClass);
        if (names.size() == 1 && "ALL".equals(names.get(0))) {
            return "DEFAULT";
        }
        return names.get(0);
    }

    public static List<String> getDatasourceNames(GrailsDomainClass domainClass) {
        Mapping mapping;
        Mapping mapping2 = mapping = GrailsHibernateUtil.isMappedWithHibernate(domainClass) ? binder.evaluateMapping(domainClass, null, false) : null;
        if (mapping == null) {
            mapping = new Mapping();
        }
        return mapping.getDatasources();
    }

    public static boolean isMappedWithHibernate(GrailsDomainClass domainClass) {
        return domainClass instanceof GrailsHibernateDomainClass || domainClass.getMappingStrategy().equals("GORM");
    }

    public static void autoAssociateBidirectionalOneToOnes(DefaultGrailsDomainClass domainClass, Object target) {
        List associations = domainClass.getAssociations();
        for (GrailsDomainClassProperty association : associations) {
            BeanWrapperImpl inverseBean;
            Object propertyValue;
            BeanWrapperImpl bean;
            Object inverseObject;
            GrailsDomainClassProperty otherSide;
            if (!association.isOneToOne() || !association.isBidirectional() || !association.isOwningSide() || !GrailsHibernateUtil.isInitialized(target, association.getName()) || (otherSide = association.getOtherSide()) == null || (inverseObject = (bean = new BeanWrapperImpl(target)).getPropertyValue(association.getName())) == null || !GrailsHibernateUtil.isInitialized(inverseObject, otherSide.getName()) || (propertyValue = (inverseBean = new BeanWrapperImpl(inverseObject)).getPropertyValue(otherSide.getName())) != null) continue;
            inverseBean.setPropertyValue(otherSide.getName(), target);
        }
    }

    public static String qualify(String prefix, String name) {
        return StringHelper.qualify((String)prefix, (String)name);
    }

    public static boolean isNotEmpty(String string) {
        return StringHelper.isNotEmpty((String)string);
    }

    public static String unqualify(String qualifiedName) {
        return StringHelper.unqualify((String)qualifiedName);
    }
}

