/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import grails.gorm.DetachedCriteria;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTemplate;
import org.codehaus.groovy.grails.orm.hibernate.exceptions.GrailsQueryException;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractStaticPersistentMethod;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.core.convert.ConversionService;

public class ExecuteQueryPersistentMethod
extends AbstractStaticPersistentMethod {
    private static final String METHOD_SIGNATURE = "executeQuery";
    private static final Pattern METHOD_PATTERN = Pattern.compile("^executeQuery$");
    private static final List<String> QUERY_META_PARAMS = Arrays.asList("max", "offset", "cache", "flushMode", "timeout", "fetchSize", "readOnly");
    private final ConversionService conversionService;

    public ExecuteQueryPersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application, ConversionService conversionService, int defaultFlushMode) {
        super(sessionFactory, classLoader, METHOD_PATTERN, application, defaultFlushMode);
        this.conversionService = conversionService;
    }

    @Override
    protected Object doInvokeInternal(Class clazz, String methodName, DetachedCriteria additionalCriteria, Object[] arguments) {
        return this.doInvokeInternal(clazz, methodName, (Closure)null, arguments);
    }

    @Override
    protected Object doInvokeInternal(Class clazz, String methodName, Closure additionalCriteria, Object[] arguments) {
        this.checkMethodSignature(clazz, arguments);
        final String query = arguments[0].toString();
        final Map queryMetaParams = this.extractQueryMetaParams(arguments);
        final List positionalParams = this.extractPositionalParams(arguments);
        final Map namedParams = this.extractNamedParams(arguments);
        return this.getHibernateTemplate().executeFind(new GrailsHibernateTemplate.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(query);
                ExecuteQueryPersistentMethod.this.getHibernateTemplate().applySettings(q);
                if (queryMetaParams.containsKey("max")) {
                    Integer maxParam = (Integer)ExecuteQueryPersistentMethod.this.conversionService.convert(queryMetaParams.get("max"), Integer.class);
                    q.setMaxResults(maxParam.intValue());
                }
                if (queryMetaParams.containsKey("offset")) {
                    Integer offsetParam = (Integer)ExecuteQueryPersistentMethod.this.conversionService.convert(queryMetaParams.get("offset"), Integer.class);
                    q.setFirstResult(offsetParam.intValue());
                }
                if (queryMetaParams.containsKey("cache")) {
                    q.setCacheable(((Boolean)queryMetaParams.get("cache")).booleanValue());
                }
                if (queryMetaParams.containsKey("fetchSize")) {
                    Integer fetchSizeParam = (Integer)ExecuteQueryPersistentMethod.this.conversionService.convert(queryMetaParams.get("fetchSize"), Integer.class);
                    q.setFetchSize(fetchSizeParam.intValue());
                }
                if (queryMetaParams.containsKey("timeout")) {
                    Integer timeoutParam = (Integer)ExecuteQueryPersistentMethod.this.conversionService.convert(queryMetaParams.get("timeout"), Integer.class);
                    q.setTimeout(timeoutParam.intValue());
                }
                if (queryMetaParams.containsKey("readOnly")) {
                    q.setReadOnly(((Boolean)queryMetaParams.get("readOnly")).booleanValue());
                }
                if (queryMetaParams.containsKey("flushMode")) {
                    q.setFlushMode((FlushMode)queryMetaParams.get("flushMode"));
                }
                int index = 0;
                for (Object e : positionalParams) {
                    q.setParameter(index++, e instanceof CharSequence ? e.toString() : e);
                }
                for (Object object : namedParams.entrySet()) {
                    Map.Entry entry = (Map.Entry)object;
                    if (!(entry.getKey() instanceof String)) {
                        throw new GrailsQueryException("Named parameter's name must be of type String");
                    }
                    String parameterName = (String)entry.getKey();
                    if (QUERY_META_PARAMS.contains(parameterName)) continue;
                    Object parameterValue = entry.getValue();
                    if (parameterValue == null) {
                        throw new IllegalArgumentException("Named parameter [" + entry.getKey() + "] value may not be null");
                    }
                    if (Collection.class.isAssignableFrom(parameterValue.getClass())) {
                        q.setParameterList(parameterName, (Collection)parameterValue);
                        continue;
                    }
                    if (parameterValue.getClass().isArray()) {
                        q.setParameterList(parameterName, (Object[])parameterValue);
                        continue;
                    }
                    if (parameterValue instanceof CharSequence) {
                        q.setParameter(parameterName, (Object)parameterValue.toString());
                        continue;
                    }
                    q.setParameter(parameterName, parameterValue);
                }
                return q.list();
            }
        });
    }

    private void checkMethodSignature(Class clazz, Object[] arguments) {
        boolean valid = true;
        if (arguments.length < 1) {
            valid = false;
        } else if (arguments.length == 3 && !(arguments[2] instanceof Map)) {
            valid = false;
        } else if (arguments.length > 3) {
            valid = false;
        }
        if (!valid) {
            throw new MissingMethodException(METHOD_SIGNATURE, clazz, arguments);
        }
    }

    private Map extractQueryMetaParams(Object[] arguments) {
        HashMap result = new HashMap();
        int metaParamsIndex = 0;
        if (arguments.length == 2 && arguments[1] instanceof Map) {
            metaParamsIndex = 1;
        } else if (arguments.length == 3) {
            metaParamsIndex = 2;
        }
        if (metaParamsIndex > 0) {
            Map sourceMap = (Map)arguments[metaParamsIndex];
            for (String queryMetaParam : QUERY_META_PARAMS) {
                if (!sourceMap.containsKey(queryMetaParam)) continue;
                result.put(queryMetaParam, sourceMap.get(queryMetaParam));
            }
        }
        return result;
    }

    private List extractPositionalParams(Object[] arguments) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (arguments.length < 2 || arguments[1] instanceof Map) {
            return result;
        }
        if (arguments[1] instanceof Collection) {
            result.addAll((Collection)arguments[1]);
        } else if (arguments[1].getClass().isArray()) {
            result.addAll(Arrays.asList((Object[])arguments[1]));
        } else {
            result.add(arguments[1]);
        }
        return result;
    }

    private Map extractNamedParams(Object[] arguments) {
        HashMap result = new HashMap();
        if (arguments.length < 2 || !(arguments[1] instanceof Map)) {
            return result;
        }
        result.putAll((Map)arguments[1]);
        return result;
    }
}

