/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import grails.util.CollectionUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.codehaus.groovy.grails.orm.hibernate.HibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.SessionFactoryProxy;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.PostDeleteEvent;
import org.grails.datastore.mapping.engine.event.PostInsertEvent;
import org.grails.datastore.mapping.engine.event.PostLoadEvent;
import org.grails.datastore.mapping.engine.event.PostUpdateEvent;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreLoadEvent;
import org.grails.datastore.mapping.engine.event.SaveOrUpdateEvent;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class ClosureEventTriggeringInterceptor
extends DefaultSaveOrUpdateEventListener
implements ApplicationContextAware,
PreLoadEventListener,
PostLoadEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
PreDeleteEventListener,
PreUpdateEventListener,
PreInsertEventListener {
    private static final long serialVersionUID = 1L;
    public static final Collection<String> IGNORED = CollectionUtils.newSet((Object[])new String[]{"version", "id"});
    public static final String ONLOAD_EVENT = "onLoad";
    public static final String ONLOAD_SAVE = "onSave";
    public static final String BEFORE_LOAD_EVENT = "beforeLoad";
    public static final String BEFORE_INSERT_EVENT = "beforeInsert";
    public static final String AFTER_INSERT_EVENT = "afterInsert";
    public static final String BEFORE_UPDATE_EVENT = "beforeUpdate";
    public static final String AFTER_UPDATE_EVENT = "afterUpdate";
    public static final String BEFORE_DELETE_EVENT = "beforeDelete";
    public static final String AFTER_DELETE_EVENT = "afterDelete";
    public static final String AFTER_LOAD_EVENT = "afterLoad";
    private ApplicationContext ctx;
    private Map<SessionFactory, HibernateDatastore> datastores;
    private static final ThreadLocal<Boolean> insertActiveThreadLocal = new ThreadLocal();
    private static final PreInsertEventListener NULLABILITY_CHECKER_INSTANCE = new NullabilityCheckerPreInsertEventListener();

    public void setDatastores(Map<SessionFactory, HibernateDatastore> datastores) {
        this.datastores = datastores;
    }

    public void onSaveOrUpdate(org.hibernate.event.spi.SaveOrUpdateEvent hibernateEvent) throws HibernateException {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new SaveOrUpdateEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
        super.onSaveOrUpdate(hibernateEvent);
    }

    public void onPreLoad(org.hibernate.event.spi.PreLoadEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PreLoadEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public void onPostLoad(org.hibernate.event.spi.PostLoadEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PostLoadEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public boolean onPreInsert(org.hibernate.event.spi.PreInsertEvent hibernateEvent) {
        PreInsertEvent event = new PreInsertEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity());
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)event);
        return event.isCancelled();
    }

    public void onPostInsert(org.hibernate.event.spi.PostInsertEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PostInsertEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent hibernateEvent) {
        org.grails.datastore.mapping.engine.event.PreUpdateEvent event = new org.grails.datastore.mapping.engine.event.PreUpdateEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity());
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)event);
        return event.isCancelled();
    }

    public void onPostUpdate(org.hibernate.event.spi.PostUpdateEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PostUpdateEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public boolean onPreDelete(PreDeleteEvent hibernateEvent) {
        org.grails.datastore.mapping.engine.event.PreDeleteEvent event = new org.grails.datastore.mapping.engine.event.PreDeleteEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity());
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)event);
        return event.isCancelled();
    }

    public void onPostDelete(org.hibernate.event.spi.PostDeleteEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PostDeleteEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.ctx = applicationContext;
    }

    private void publishEvent(AbstractEvent hibernateEvent, AbstractPersistenceEvent mappingEvent) {
        mappingEvent.setNativeEvent((Serializable)hibernateEvent);
        this.ctx.publishEvent((ApplicationEvent)mappingEvent);
    }

    private Datastore findDatastore(AbstractEvent hibernateEvent) {
        Datastore datastore;
        SessionFactory sessionFactory = hibernateEvent.getSession().getSessionFactory();
        if (!(sessionFactory instanceof SessionFactoryProxy)) {
            for (Map.Entry<SessionFactory, HibernateDatastore> entry : this.datastores.entrySet()) {
                SessionFactory sf = entry.getKey();
                if (!(sf instanceof SessionFactoryProxy) || ((SessionFactoryProxy)sf).getCurrentSessionFactory() != sessionFactory) continue;
                return (Datastore)entry.getValue();
            }
        }
        if ((datastore = (Datastore)this.datastores.get(sessionFactory)) == null && this.datastores.size() == 1) {
            datastore = (Datastore)this.datastores.values().iterator().next();
        }
        return datastore;
    }

    public static final void addNullabilityCheckerPreInsertEventListener(EventListenerRegistry listenerRegistry) {
        listenerRegistry.getEventListenerGroup(EventType.PRE_INSERT).appendListener((Object)NULLABILITY_CHECKER_INSTANCE);
    }

    protected Boolean getAssumedUnsaved() {
        return insertActiveThreadLocal.get();
    }

    public static void markInsertActive() {
        insertActiveThreadLocal.set(true);
    }

    public static void resetInsertActive() {
        insertActiveThreadLocal.remove();
    }

    private static class NullabilityCheckerPreInsertEventListener
    implements PreInsertEventListener {
        private NullabilityCheckerPreInsertEventListener() {
        }

        public boolean onPreInsert(org.hibernate.event.spi.PreInsertEvent event) {
            new Nullability((SessionImplementor)event.getSession()).checkNullability(event.getState(), event.getPersister(), false);
            return false;
        }
    }
}

