/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.validation;

import java.util.ArrayList;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.orm.hibernate.proxy.HibernateProxyHandler;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.codehaus.groovy.grails.validation.GrailsDomainClassValidator;
import org.grails.datastore.gorm.support.BeforeValidateHelper;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.collection.spi.PersistentCollection;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSourceAware;
import org.springframework.validation.Errors;

public class HibernateDomainClassValidator
extends GrailsDomainClassValidator
implements MessageSourceAware {
    private BeforeValidateHelper beforeValidateHelper = new BeforeValidateHelper();
    private SessionFactory sessionFactory;
    private ProxyHandler proxyHandler = new HibernateProxyHandler();

    @Autowired(required=false)
    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    protected GrailsDomainClass getAssociatedDomainClassFromApplication(Object associatedObject) {
        String associatedObjectType = Hibernate.getClass((Object)associatedObject).getName();
        return (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", associatedObjectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Object obj, Errors errors, boolean cascade) {
        Session session = this.sessionFactory.getCurrentSession();
        FlushMode previousMode = null;
        try {
            if (session != null) {
                previousMode = session.getFlushMode();
                session.setFlushMode(FlushMode.MANUAL);
            }
            super.validate(obj, errors, cascade);
        }
        finally {
            if (session != null && previousMode != null && !errors.hasErrors()) {
                session.setFlushMode(previousMode);
            }
        }
    }

    protected void cascadeValidationToMany(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty, String propertyName) {
        Object collection = bean.getPropertyValue(propertyName);
        if (collection == null) {
            return;
        }
        if (collection instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)collection;
            if (persistentCollection.wasInitialized()) {
                super.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
            }
        } else {
            super.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
        }
    }

    protected void cascadeValidationToOne(Errors errors, BeanWrapper bean, Object associatedObject, GrailsDomainClassProperty persistentProperty, String propertyName, Object indexOrKey) {
        if (this.proxyHandler.isInitialized(associatedObject)) {
            Object object = associatedObject = this.proxyHandler.isProxy(associatedObject) ? this.proxyHandler.unwrapIfProxy(associatedObject) : associatedObject;
            if (associatedObject != null) {
                this.cascadeBeforeValidate(associatedObject);
                super.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName, indexOrKey);
            }
        }
    }

    protected void cascadeBeforeValidate(Object associatedObject) {
        GrailsDomainClass associatedDomainClass = this.getAssociatedDomainClassFromApplication(associatedObject);
        if (associatedDomainClass != null) {
            this.beforeValidateHelper.invokeBeforeValidate(associatedObject, new ArrayList(associatedDomainClass.getConstrainedProperties().keySet()));
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

