/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import groovy.util.ConfigObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.support.encoding.CodecLookupHelper;
import org.codehaus.groovy.grails.support.encoding.Encoder;

public class FilteringCodecsByContentTypeSettings {
    private static final String WILDCARD_CONTENT_TYPE = "*/*";
    public static final String CONFIG_PROPERTY_CODEC_FOR_CONTENT_TYPE = "grails.views.filteringCodecForContentType";
    public static final String BEAN_NAME = "filteringCodecsByContentTypeSettings";
    Map<String, Encoder> contentTypeToEncoderMapping;
    Map<Pattern, Encoder> contentTypePatternToEncoderMapping;

    public FilteringCodecsByContentTypeSettings(GrailsApplication grailsApplication) {
        this.initialize(grailsApplication);
    }

    public void initialize(GrailsApplication grailsApplication) {
        this.contentTypeToEncoderMapping = null;
        this.contentTypePatternToEncoderMapping = null;
        Object codecForContentTypeConfig = this.getConfigSettings(grailsApplication.getConfig());
        if (codecForContentTypeConfig != null) {
            if (codecForContentTypeConfig instanceof Map) {
                this.contentTypeToEncoderMapping = new LinkedHashMap<String, Encoder>();
                this.contentTypePatternToEncoderMapping = new LinkedHashMap<Pattern, Encoder>();
                Map codecForContentTypeMapping = (Map)codecForContentTypeConfig;
                for (Map.Entry entry : codecForContentTypeMapping.entrySet()) {
                    Encoder encoder = CodecLookupHelper.lookupEncoder((GrailsApplication)grailsApplication, (String)String.valueOf(entry.getValue()));
                    if (entry.getKey() instanceof Pattern) {
                        this.contentTypePatternToEncoderMapping.put((Pattern)entry.getKey(), encoder);
                        continue;
                    }
                    this.contentTypeToEncoderMapping.put(String.valueOf(entry.getKey()), encoder);
                }
            } else {
                throw new IllegalStateException("grails.views.filteringCodecForContentType only accepts a configuration that is a java.util.Map instance");
            }
        }
    }

    public Encoder getEncoderForContentType(String contentType) {
        Encoder encoder;
        if (this.contentTypeToEncoderMapping == null) {
            return null;
        }
        if (contentType == null) {
            contentType = WILDCARD_CONTENT_TYPE;
        }
        if ((encoder = this.contentTypeToEncoderMapping.get(contentType)) != null) {
            return encoder;
        }
        for (Map.Entry<Pattern, Encoder> entry : this.contentTypePatternToEncoderMapping.entrySet()) {
            if (!entry.getKey().matcher(contentType).matches()) continue;
            return encoder;
        }
        return this.contentTypeToEncoderMapping.get(WILDCARD_CONTENT_TYPE);
    }

    protected Object getConfigSettings(ConfigObject config) {
        Object viewsConfig;
        Object grailsConfig;
        Object settings = null;
        if (config != null && (grailsConfig = config.get((Object)"grails")) instanceof Map && (viewsConfig = ((Map)grailsConfig).get("views")) instanceof Map) {
            settings = ((Map)viewsConfig).get("filteringCodecForContentType");
        }
        return settings;
    }
}

