/*
 * Copyright 2010 Grails Plugin Collective
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package grails.plugin.rendering.datauri

import org.slf4j.LoggerFactory
import org.xhtmlrenderer.swing.NaiveUserAgent

class DataUriAwareNaiveUserAgent extends NaiveUserAgent {

	private static log = LoggerFactory.getLogger(this)

	protected InputStream resolveAndOpenStream(String uri) {
		if (DataUri.isDataUri(uri)) {
			new DataUri(uri).inputStream
		} else {
			super.resolveAndOpenStream(uri)
		}
	}

	String resolveURI(String uri) {
		if (DataUri.isDataUri(uri)) {
			uri
		} else {
			super.resolveURI(uri)
		}
	}
}
