/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.ehcache.internal.DeprecationLogger;
import org.hibernate.cache.ehcache.internal.EhCacheMessageLogger;
import org.hibernate.cache.ehcache.internal.HibernateEhcacheUtils;
import org.hibernate.cache.ehcache.internal.StorageAccessImpl;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.cache.spi.support.RegionFactoryTemplate;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.cache.spi.support.StorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.jboss.logging.Logger;

public class EhcacheRegionFactory
extends RegionFactoryTemplate {
    private static final Logger LOG = Logger.getLogger(EhcacheRegionFactory.class);
    private final CacheKeysFactory cacheKeysFactory;
    private volatile CacheManager cacheManager;

    public EhcacheRegionFactory() {
        this((CacheKeysFactory)DefaultCacheKeysFactory.INSTANCE);
    }

    public EhcacheRegionFactory(CacheKeysFactory cacheKeysFactory) {
        this.cacheKeysFactory = cacheKeysFactory;
        DeprecationLogger.INSTANCE.logDeprecation();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected CacheKeysFactory getImplicitCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    protected DomainDataStorageAccess createDomainDataStorageAccess(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return new StorageAccessImpl(this.getOrCreateCache(regionConfig.getRegionName(), buildingContext.getSessionFactory()));
    }

    protected StorageAccess createQueryResultsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new StorageAccessImpl(this.getOrCreateCache(regionName, sessionFactory));
    }

    protected StorageAccess createTimestampsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new StorageAccessImpl(this.getOrCreateCache(regionName, sessionFactory));
    }

    protected Cache getOrCreateCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        Cache cache = this.cacheManager.getCache(qualifiedRegionName);
        if (cache == null) {
            return this.createCache(qualifiedRegionName);
        }
        return cache;
    }

    protected Cache createCache(String regionName) {
        throw new CacheException("On-the-fly creation of JCache Cache objects is not supported [" + regionName + "]");
    }

    protected boolean isStarted() {
        return super.isStarted() && this.cacheManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareForUse(SessionFactoryOptions settings, Map configValues) {
        EhcacheRegionFactory ehcacheRegionFactory = this;
        synchronized (ehcacheRegionFactory) {
            this.cacheManager = this.resolveCacheManager(settings, configValues);
            if (this.cacheManager == null) {
                throw new CacheException("Could not start Ehcache CacheManager");
            }
        }
    }

    protected CacheManager resolveCacheManager(SessionFactoryOptions settings, Map properties) {
        Object explicitCacheManager = properties.get("hibernate.cache.ehcache.cache_manager");
        if (explicitCacheManager != null) {
            return this.useExplicitCacheManager(settings, explicitCacheManager);
        }
        return EhcacheRegionFactory.useNormalCacheManager(settings, properties);
    }

    protected static CacheManager useNormalCacheManager(SessionFactoryOptions settings, Map properties) {
        try {
            String configurationResourceName = null;
            if (properties != null) {
                configurationResourceName = (String)properties.get("net.sf.ehcache.configurationResourceName");
            }
            if (configurationResourceName == null || configurationResourceName.length() == 0) {
                Configuration configuration = ConfigurationFactory.parseConfiguration();
                HibernateEhcacheUtils.setCacheManagerNameIfNeeded(settings, configuration, properties);
                return new CacheManager(configuration);
            }
            URL url = EhcacheRegionFactory.loadResource(configurationResourceName, settings);
            Configuration configuration = HibernateEhcacheUtils.loadAndCorrectConfiguration(url);
            HibernateEhcacheUtils.setCacheManagerNameIfNeeded(settings, configuration, properties);
            return new CacheManager(configuration);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new CacheException("Attempt to restart an already started EhCacheRegionFactory. Use sessionFactory.close() between repeated calls to buildSessionFactory. Consider using SingletonEhCacheRegionFactory. Error from ehcache was: " + e.getMessage());
            }
            throw new CacheException((Throwable)e);
        }
    }

    private static URL loadResource(String configurationResourceName, SessionFactoryOptions settings) {
        URL url = ((ClassLoaderService)settings.getServiceRegistry().getService(ClassLoaderService.class)).locateResource(configurationResourceName);
        if (url == null) {
            ClassLoader standardClassloader = Thread.currentThread().getContextClassLoader();
            if (standardClassloader != null) {
                url = standardClassloader.getResource(configurationResourceName);
            }
            if (url == null) {
                url = EhcacheRegionFactory.class.getResource(configurationResourceName);
            }
            if (url == null) {
                try {
                    url = new URL(configurationResourceName);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Creating EhCacheRegionFactory from a specified resource: %s.  Resolved to URL: %s", (Object)configurationResourceName, (Object)url);
        }
        if (url == null) {
            EhCacheMessageLogger.INSTANCE.unableToLoadConfiguration(configurationResourceName);
        }
        return url;
    }

    protected URL loadResource(String configurationResourceName) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot load resource through a non-started EhcacheRegionFactory");
        }
        return EhcacheRegionFactory.loadResource(configurationResourceName, this.getOptions());
    }

    private CacheManager useExplicitCacheManager(SessionFactoryOptions settings, Object setting) {
        if (setting instanceof CacheManager) {
            return (CacheManager)setting;
        }
        Class cacheManagerClass = setting instanceof Class ? (Class)setting : ((ClassLoaderService)settings.getServiceRegistry().getService(ClassLoaderService.class)).classForName(setting.toString());
        try {
            return (CacheManager)cacheManagerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CacheException("Could not use explicit CacheManager : " + setting);
        }
    }

    protected void releaseFromUse() {
        try {
            this.cacheManager.shutdown();
        }
        finally {
            this.cacheManager = null;
        }
    }
}

