/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableGroup;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class OracleLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public OracleLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean needsRecursiveKeywordInWithClause() {
        return false;
    }

    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    protected boolean supportsRecursiveSearchClause() {
        return true;
    }

    protected boolean supportsRecursiveCycleClause() {
        return true;
    }

    public void visitSqlSelection(SqlSelection sqlSelection) {
        if (this.getCurrentCteStatement() != null && this.getCurrentCteStatement().getMaterialization() == CteMaterialization.MATERIALIZED) {
            this.appendSql("/*+ materialize */ ");
        }
        super.visitSqlSelection(sqlSelection);
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        AbstractSqlAstTranslator.LockStrategy strategy = super.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
        boolean followOnLockingDisabled = Boolean.FALSE.equals(followOnLocking);
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && querySpec.hasSortSpecifications()) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with ORDER BY is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.isPartOfQueryGroup()) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.hasSetOperations(querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.useOffsetFetchClause((QueryPart)querySpec) && !this.isRowsOnlyFetchClauseType((QueryPart)querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with FETCH is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON) {
            boolean hasOffset;
            if (querySpec.isRoot() && this.hasLimit() && this.getLimit().getFirstRow() != null) {
                hasOffset = true;
                this.addAppliedParameterBinding(this.getOffsetParameter(), null);
            } else {
                boolean bl = hasOffset = querySpec.getOffsetClauseExpression() != null;
            }
            if (hasOffset) {
                if (followOnLockingDisabled) {
                    throw new IllegalQueryOperationException("Locking with OFFSET is not supported");
                }
                strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
            }
        }
        return strategy;
    }

    private boolean hasSetOperations(QuerySpec querySpec) {
        return querySpec.getFromClause().queryTableGroups(group -> group instanceof UnionTableGroup ? group : null) != null;
    }

    private boolean isPartOfQueryGroup() {
        return this.getQueryPartStack().findCurrentFirst(part -> part instanceof QueryGroup ? part : null) != null;
    }

    protected boolean shouldEmulateLateralWithIntersect(QueryPart queryPart) {
        return !queryPart.hasOffsetOrFetchClause();
    }

    protected boolean supportsNestedSubqueryCorrelation() {
        return false;
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        boolean hasLimit;
        if (this.getQueryPartForRowNumbering() == queryPart) {
            return false;
        }
        boolean bl = hasLimit = queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseExpression() != null || queryPart.getOffsetClauseExpression() != null;
        if (!hasLimit) {
            return false;
        }
        if (this.supportsOffsetFetchClause()) {
            return !queryPart.hasSortSpecifications() && !this.hasOffset(queryPart) || queryPart instanceof QueryGroup && this.getClauseStack().isEmpty() && this.getStatement() instanceof InsertSelectStatement;
        }
        return true;
    }

    protected FetchClauseType getFetchClauseTypeForRowNumbering(QueryPart queryPart) {
        boolean hasOffset;
        FetchClauseType fetchClauseType = super.getFetchClauseTypeForRowNumbering(queryPart);
        if (queryPart.isRoot() && this.hasLimit()) {
            hasOffset = this.getLimit().getFirstRow() != null;
        } else {
            boolean bl = hasOffset = queryPart.getOffsetClauseExpression() != null;
        }
        if (queryPart instanceof QuerySpec && !hasOffset && fetchClauseType == FetchClauseType.ROWS_ONLY) {
            return null;
        }
        return fetchClauseType;
    }

    protected void emulateFetchOffsetWithWindowFunctions(QueryPart queryPart, Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean emulateFetchClause) {
        if (queryPart instanceof QuerySpec && offsetExpression == null && fetchClauseType == FetchClauseType.ROWS_ONLY) {
            QuerySpec querySpec = (QuerySpec)queryPart;
            this.withRowNumbering((QueryPart)querySpec, true, () -> {
                this.appendSql("select * from ");
                this.emulateFetchOffsetWithWindowFunctionsVisitQueryPart((QueryPart)querySpec);
                this.appendSql(" where rownum<=");
                Stack clauseStack = this.getClauseStack();
                clauseStack.push((Object)Clause.WHERE);
                try {
                    fetchExpression.accept((SqlAstWalker)this);
                    clauseStack.pop();
                    clauseStack.push((Object)Clause.FOR_UPDATE);
                    this.visitForUpdateClause(querySpec);
                }
                finally {
                    clauseStack.pop();
                }
            });
        } else {
            super.emulateFetchOffsetWithWindowFunctions(queryPart, offsetExpression, fetchExpression, fetchClauseType, emulateFetchClause);
        }
    }

    protected void visitOrderBy(List<SortSpecification> sortSpecifications) {
        QuerySpec querySpec;
        QueryPart queryPartForRowNumbering = this.getQueryPartForRowNumbering();
        if (queryPartForRowNumbering == null) {
            this.renderOrderBy(true, sortSpecifications);
        } else if (!(this.getFetchClauseTypeForRowNumbering(queryPartForRowNumbering) != null || (querySpec = (QuerySpec)queryPartForRowNumbering).getOffsetClauseExpression() != null || querySpec.isRoot() && this.getOffsetParameter() != null)) {
            this.renderOrderBy(true, sortSpecifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitValuesList(List<Values> valuesList) {
        if (valuesList.size() < 2) {
            super.visitValuesList(valuesList);
        } else {
            String separator = "";
            Stack clauseStack = this.getClauseStack();
            try {
                clauseStack.push((Object)Clause.VALUES);
                for (Values values : valuesList) {
                    this.appendSql(separator);
                    this.renderExpressionsAsSubquery(values.getExpressions());
                    separator = " union all ";
                }
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        this.append("table(");
        tableReference.getFunctionExpression().accept((SqlAstWalker)this);
        this.append(')');
        this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetFetchClause()) {
                if (this.getQueryPartStack().depth() > 1 && queryPart.hasSortSpecifications() && this.getQueryPartStack().peek(1) instanceof QueryGroup && (queryPart.isRoot() && !this.hasLimit() || !queryPart.hasOffsetOrFetchClause())) {
                    this.appendSql(" offset 0 rows");
                } else {
                    this.renderOffsetFetchClause(queryPart, true);
                }
            } else {
                this.assertRowsOnlyFetchClauseType(queryPart);
            }
        }
    }

    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (!queryPart.hasSortSpecifications()) {
            this.appendSql("rownum");
        } else {
            super.renderRowNumber(selectClause, queryPart);
        }
    }

    public void visitOver(Over<?> over) {
        Expression expression = over.getExpression();
        if (expression instanceof FunctionExpression && "row_number".equals(((FunctionExpression)expression).getFunctionName()) && over.getPartitions().isEmpty() && over.getOrderList().isEmpty() && over.getStartKind() == FrameKind.UNBOUNDED_PRECEDING && over.getEndKind() == FrameKind.CURRENT_ROW && over.getExclusion() == FrameExclusion.NO_OTHERS) {
            this.append("row_number() over(order by 1)");
            return;
        }
        super.visitOver(over);
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType == null || lhsExpressionType.getJdbcTypeCount() != 1) {
            this.renderComparisonEmulateDecode(lhs, operator, rhs);
            return;
        }
        switch (lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode()) {
            case 2009: {
                switch (operator) {
                    case EQUAL: 
                    case NOT_DISTINCT_FROM: {
                        this.appendSql("0=");
                        break;
                    }
                    case NOT_EQUAL: 
                    case DISTINCT_FROM: {
                        this.appendSql("1=");
                        break;
                    }
                    default: {
                        this.renderComparisonEmulateDecode(lhs, operator, rhs);
                        return;
                    }
                }
                this.appendSql("existsnode(xmldiff(");
                lhs.accept((SqlAstWalker)this);
                this.appendSql(',');
                rhs.accept((SqlAstWalker)this);
                this.appendSql("),'/*[local-name()=''xdiff'']/*')");
                break;
            }
            case 2004: 
            case 2005: 
            case 2011: {
                switch (operator) {
                    case EQUAL: {
                        this.appendSql("0=");
                        break;
                    }
                    case NOT_EQUAL: {
                        this.appendSql("-1=");
                        break;
                    }
                    default: {
                        this.renderComparisonEmulateDecode(lhs, operator, rhs);
                        return;
                    }
                }
                this.appendSql("dbms_lob.compare(");
                lhs.accept((SqlAstWalker)this);
                this.appendSql(',');
                rhs.accept((SqlAstWalker)this);
                this.appendSql(')');
                break;
            }
            default: {
                this.renderComparisonEmulateDecode(lhs, operator, rhs);
            }
        }
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, boolean inSelect) {
        if (this.getDialect().getVersion().isBefore(9)) {
            this.visitDecodeCaseSearchedExpression(caseSearchedExpression);
        } else {
            super.visitCaseSearchedExpression(caseSearchedExpression, inSelect);
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    protected boolean supportsDuplicateSelectItemsInQueryGroup() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return this.getDialect().getVersion().isSameOrAfter(8, 2);
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInSubQuery() {
        return this.getDialect().getVersion().isSameOrAfter(9);
    }

    protected String getFromDual() {
        return " from dual";
    }

    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().supportsFetchClause(FetchClauseType.ROWS_ONLY);
    }

    protected void visitSetAssignment(Assignment assignment) {
        List columnReferences = assignment.getAssignable().getColumnReferences();
        if (columnReferences.size() == 1) {
            ((ColumnReference)columnReferences.get(0)).appendColumnForWrite((SqlAppender)this);
            this.appendSql('=');
            Expression assignedValue = assignment.getAssignedValue();
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple((SqlAstNode)assignedValue);
            if (sqlTuple != null) {
                assert (sqlTuple.getExpressions().size() == 1);
                ((Expression)sqlTuple.getExpressions().get(0)).accept((SqlAstWalker)this);
            } else {
                assignedValue.accept((SqlAstWalker)this);
            }
        } else {
            int separator = 40;
            for (ColumnReference columnReference : columnReferences) {
                this.appendSql((char)separator);
                columnReference.appendColumnForWrite((SqlAppender)this);
                separator = 44;
            }
            this.appendSql(")=");
            assignment.getAssignedValue().accept((SqlAstWalker)this);
        }
    }
}

