/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.convert.StringBufferConverter;
import hprose.io.unserialize.BaseUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.ReferenceReader;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.lang.reflect.Type;

public final class StringBufferUnserializer
extends BaseUnserializer<StringBuffer> {
    public static final StringBufferUnserializer instance = new StringBufferUnserializer();

    @Override
    public StringBuffer unserialize(Reader reader, int tag, Type type) throws IOException {
        StringBufferConverter converter = StringBufferConverter.instance;
        switch (tag) {
            case 101: {
                return new StringBuffer();
            }
            case 115: {
                return converter.convertTo(ReferenceReader.readChars(reader));
            }
            case 117: {
                return new StringBuffer().append(ValueReader.readChar(reader));
            }
            case 105: {
                return new StringBuffer(ValueReader.readUntil(reader, 59));
            }
            case 108: {
                return new StringBuffer(ValueReader.readUntil(reader, 59));
            }
            case 100: {
                return new StringBuffer(ValueReader.readUntil(reader, 59));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new StringBuffer().append((char)tag);
        }
        switch (tag) {
            case 116: {
                return new StringBuffer("true");
            }
            case 102: {
                return new StringBuffer("false");
            }
            case 78: {
                return new StringBuffer("NaN");
            }
            case 73: {
                return new StringBuffer(reader.stream.read() == 43 ? "Infinity" : "-Infinity");
            }
            case 68: {
                return ReferenceReader.readDateTime(reader).toStringBuffer();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toStringBuffer();
            }
            case 103: {
                return new StringBuffer(ReferenceReader.readUUID(reader).toString());
            }
        }
        return (StringBuffer)super.unserialize(reader, tag, type);
    }

    public StringBuffer read(Reader reader) throws IOException {
        return (StringBuffer)this.read(reader, (Type)((Object)StringBuffer.class));
    }
}

