/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.ArrayListUnserializer;
import hprose.io.unserialize.ArrayUnserializer;
import hprose.io.unserialize.AtomicBooleanUnserializer;
import hprose.io.unserialize.AtomicIntegerArrayUnserializer;
import hprose.io.unserialize.AtomicIntegerUnserializer;
import hprose.io.unserialize.AtomicLongArrayUnserializer;
import hprose.io.unserialize.AtomicLongUnserializer;
import hprose.io.unserialize.AtomicReferenceArrayUnserializer;
import hprose.io.unserialize.AtomicReferenceUnserializer;
import hprose.io.unserialize.BigDecimalArrayUnserializer;
import hprose.io.unserialize.BigDecimalUnserializer;
import hprose.io.unserialize.BigIntegerArrayUnserializer;
import hprose.io.unserialize.BigIntegerUnserializer;
import hprose.io.unserialize.BooleanArrayUnserializer;
import hprose.io.unserialize.BooleanObjectUnserializer;
import hprose.io.unserialize.BooleanUnserializer;
import hprose.io.unserialize.ByteArrayUnserializer;
import hprose.io.unserialize.ByteObjectUnserializer;
import hprose.io.unserialize.ByteUnserializer;
import hprose.io.unserialize.BytesArrayUnserializer;
import hprose.io.unserialize.CalendarArrayUnserializer;
import hprose.io.unserialize.CalendarUnserializer;
import hprose.io.unserialize.CaseInsensitiveMapUnserializer;
import hprose.io.unserialize.CharArrayUnserializer;
import hprose.io.unserialize.CharObjectUnserializer;
import hprose.io.unserialize.CharUnserializer;
import hprose.io.unserialize.CharsArrayUnserializer;
import hprose.io.unserialize.CollectionUnserializer;
import hprose.io.unserialize.DateArrayUnserializer;
import hprose.io.unserialize.DateTimeArrayUnserializer;
import hprose.io.unserialize.DateTimeUnserializer;
import hprose.io.unserialize.DateUnserializer;
import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.DoubleArrayUnserializer;
import hprose.io.unserialize.DoubleObjectUnserializer;
import hprose.io.unserialize.DoubleUnserializer;
import hprose.io.unserialize.EnumUnserializer;
import hprose.io.unserialize.FloatArrayUnserializer;
import hprose.io.unserialize.FloatObjectUnserializer;
import hprose.io.unserialize.FloatUnserializer;
import hprose.io.unserialize.HashMapUnserializer;
import hprose.io.unserialize.HashSetUnserializer;
import hprose.io.unserialize.HproseDateTimeUnserializer;
import hprose.io.unserialize.IntArrayUnserializer;
import hprose.io.unserialize.IntObjectUnserializer;
import hprose.io.unserialize.IntUnserializer;
import hprose.io.unserialize.LinkedCaseInsensitiveMapUnserializer;
import hprose.io.unserialize.LinkedHashMapUnserializer;
import hprose.io.unserialize.LinkedListUnserializer;
import hprose.io.unserialize.LocaleUnserializer;
import hprose.io.unserialize.LongArrayUnserializer;
import hprose.io.unserialize.LongObjectUnserializer;
import hprose.io.unserialize.LongUnserializer;
import hprose.io.unserialize.MapUnserializer;
import hprose.io.unserialize.ObjectUnserializer;
import hprose.io.unserialize.PatternUnserializer;
import hprose.io.unserialize.ShortArrayUnserializer;
import hprose.io.unserialize.ShortObjectUnserializer;
import hprose.io.unserialize.ShortUnserializer;
import hprose.io.unserialize.StringArrayUnserializer;
import hprose.io.unserialize.StringBufferArrayUnserializer;
import hprose.io.unserialize.StringBufferUnserializer;
import hprose.io.unserialize.StringBuilderArrayUnserializer;
import hprose.io.unserialize.StringBuilderUnserializer;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.TimeArrayUnserializer;
import hprose.io.unserialize.TimeUnserializer;
import hprose.io.unserialize.TimeZoneUnserializer;
import hprose.io.unserialize.TimestampArrayUnserializer;
import hprose.io.unserialize.TimestampUnserializer;
import hprose.io.unserialize.TreeMapUnserializer;
import hprose.io.unserialize.TreeSetUnserializer;
import hprose.io.unserialize.URIUnserializer;
import hprose.io.unserialize.URLUnserializer;
import hprose.io.unserialize.UUIDArrayUnserializer;
import hprose.io.unserialize.UUIDUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.util.CaseInsensitiveMap;
import hprose.util.DateTime;
import hprose.util.JdkVersion;
import hprose.util.LinkedCaseInsensitiveMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.regex.Pattern;

public final class UnserializerFactory {
    private static final ConcurrentHashMap<Class<?>, Unserializer> unserializers = new ConcurrentHashMap();

    public static final Unserializer get(Class<?> type) {
        Unserializer unserializer = unserializers.get(type);
        if (unserializer == null) {
            unserializer = type.isEnum() ? EnumUnserializer.instance : (type.isArray() ? ArrayUnserializer.instance : (Map.class.isAssignableFrom(type) ? MapUnserializer.instance : (Collection.class.isAssignableFrom(type) ? CollectionUnserializer.instance : (TimeZone.class.isAssignableFrom(type) ? TimeZoneUnserializer.instance : (Calendar.class.isAssignableFrom(type) ? CalendarUnserializer.instance : ObjectUnserializer.instance)))));
            unserializers.put(type, unserializer);
        }
        return unserializer;
    }

    public static final void register(Class<?> type, Unserializer unserializer) {
        unserializers.put(type, unserializer);
    }

    static {
        unserializers.put(Void.TYPE, DefaultUnserializer.instance);
        unserializers.put(Boolean.TYPE, BooleanUnserializer.instance);
        unserializers.put(Character.TYPE, CharUnserializer.instance);
        unserializers.put(Byte.TYPE, ByteUnserializer.instance);
        unserializers.put(Short.TYPE, ShortUnserializer.instance);
        unserializers.put(Integer.TYPE, IntUnserializer.instance);
        unserializers.put(Long.TYPE, LongUnserializer.instance);
        unserializers.put(Float.TYPE, FloatUnserializer.instance);
        unserializers.put(Double.TYPE, DoubleUnserializer.instance);
        unserializers.put(Object.class, DefaultUnserializer.instance);
        unserializers.put(Void.class, DefaultUnserializer.instance);
        unserializers.put(Boolean.class, BooleanObjectUnserializer.instance);
        unserializers.put(Character.class, CharObjectUnserializer.instance);
        unserializers.put(Byte.class, ByteObjectUnserializer.instance);
        unserializers.put(Short.class, ShortObjectUnserializer.instance);
        unserializers.put(Integer.class, IntObjectUnserializer.instance);
        unserializers.put(Long.class, LongObjectUnserializer.instance);
        unserializers.put(Float.class, FloatObjectUnserializer.instance);
        unserializers.put(Double.class, DoubleObjectUnserializer.instance);
        unserializers.put(String.class, StringUnserializer.instance);
        unserializers.put(BigInteger.class, BigIntegerUnserializer.instance);
        unserializers.put(java.sql.Date.class, DateUnserializer.instance);
        unserializers.put(Time.class, TimeUnserializer.instance);
        unserializers.put(Timestamp.class, TimestampUnserializer.instance);
        unserializers.put(Date.class, DateTimeUnserializer.instance);
        unserializers.put(Calendar.class, CalendarUnserializer.instance);
        unserializers.put(BigDecimal.class, BigDecimalUnserializer.instance);
        unserializers.put(StringBuilder.class, StringBuilderUnserializer.instance);
        unserializers.put(StringBuffer.class, StringBufferUnserializer.instance);
        unserializers.put(UUID.class, UUIDUnserializer.instance);
        unserializers.put(boolean[].class, BooleanArrayUnserializer.instance);
        unserializers.put(char[].class, CharArrayUnserializer.instance);
        unserializers.put(byte[].class, ByteArrayUnserializer.instance);
        unserializers.put(short[].class, ShortArrayUnserializer.instance);
        unserializers.put(int[].class, IntArrayUnserializer.instance);
        unserializers.put(long[].class, LongArrayUnserializer.instance);
        unserializers.put(float[].class, FloatArrayUnserializer.instance);
        unserializers.put(double[].class, DoubleArrayUnserializer.instance);
        unserializers.put(String[].class, StringArrayUnserializer.instance);
        unserializers.put(BigInteger[].class, BigIntegerArrayUnserializer.instance);
        unserializers.put(java.sql.Date[].class, DateArrayUnserializer.instance);
        unserializers.put(Time[].class, TimeArrayUnserializer.instance);
        unserializers.put(Timestamp[].class, TimestampArrayUnserializer.instance);
        unserializers.put(Date[].class, DateTimeArrayUnserializer.instance);
        unserializers.put(Calendar[].class, CalendarArrayUnserializer.instance);
        unserializers.put(BigDecimal[].class, BigDecimalArrayUnserializer.instance);
        unserializers.put(StringBuilder[].class, StringBuilderArrayUnserializer.instance);
        unserializers.put(StringBuffer[].class, StringBufferArrayUnserializer.instance);
        unserializers.put(UUID[].class, UUIDArrayUnserializer.instance);
        unserializers.put(char[][].class, CharsArrayUnserializer.instance);
        unserializers.put(byte[][].class, BytesArrayUnserializer.instance);
        unserializers.put(ArrayList.class, ArrayListUnserializer.instance);
        unserializers.put(AbstractList.class, ArrayListUnserializer.instance);
        unserializers.put(AbstractCollection.class, ArrayListUnserializer.instance);
        unserializers.put(List.class, ArrayListUnserializer.instance);
        unserializers.put(Collection.class, ArrayListUnserializer.instance);
        unserializers.put(LinkedList.class, LinkedListUnserializer.instance);
        unserializers.put(AbstractSequentialList.class, LinkedListUnserializer.instance);
        unserializers.put(HashSet.class, HashSetUnserializer.instance);
        unserializers.put(AbstractSet.class, HashSetUnserializer.instance);
        unserializers.put(Set.class, HashSetUnserializer.instance);
        unserializers.put(TreeSet.class, TreeSetUnserializer.instance);
        unserializers.put(SortedSet.class, TreeSetUnserializer.instance);
        unserializers.put(LinkedCaseInsensitiveMap.class, LinkedCaseInsensitiveMapUnserializer.instance);
        unserializers.put(LinkedHashMap.class, LinkedHashMapUnserializer.instance);
        unserializers.put(CaseInsensitiveMap.class, CaseInsensitiveMapUnserializer.instance);
        unserializers.put(HashMap.class, HashMapUnserializer.instance);
        unserializers.put(AbstractMap.class, HashMapUnserializer.instance);
        unserializers.put(Map.class, LinkedHashMapUnserializer.instance);
        unserializers.put(TreeMap.class, TreeMapUnserializer.instance);
        unserializers.put(SortedMap.class, TreeMapUnserializer.instance);
        unserializers.put(AtomicBoolean.class, AtomicBooleanUnserializer.instance);
        unserializers.put(AtomicInteger.class, AtomicIntegerUnserializer.instance);
        unserializers.put(AtomicLong.class, AtomicLongUnserializer.instance);
        unserializers.put(AtomicReference.class, AtomicReferenceUnserializer.instance);
        unserializers.put(AtomicIntegerArray.class, AtomicIntegerArrayUnserializer.instance);
        unserializers.put(AtomicLongArray.class, AtomicLongArrayUnserializer.instance);
        unserializers.put(AtomicReferenceArray.class, AtomicReferenceArrayUnserializer.instance);
        unserializers.put(URL.class, URLUnserializer.instance);
        unserializers.put(URI.class, URIUnserializer.instance);
        unserializers.put(Locale.class, LocaleUnserializer.instance);
        unserializers.put(Pattern.class, PatternUnserializer.instance);
        unserializers.put(TimeZone.class, TimeZoneUnserializer.instance);
        unserializers.put(DateTime.class, HproseDateTimeUnserializer.instance);
        if (JdkVersion.majorJavaVersion >= 8) {
            try {
                Class.forName("hprose.io.unserialize.java8.UnserializerLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

