/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.convert.java8;

import hprose.io.convert.Converter;
import hprose.util.DateTime;
import java.lang.reflect.Type;
import java.time.MonthDay;

public class MonthDayConverter
implements Converter<MonthDay> {
    public static final MonthDayConverter instance = new MonthDayConverter();

    public MonthDay convertTo(DateTime dt) {
        return MonthDay.of(dt.month, dt.day);
    }

    @Override
    public MonthDay convertTo(Object obj, Type type) {
        if (obj instanceof DateTime) {
            return this.convertTo((DateTime)obj);
        }
        if (obj instanceof String) {
            return MonthDay.parse((String)obj);
        }
        if (obj instanceof char[]) {
            return MonthDay.parse(new String((char[])obj));
        }
        return (MonthDay)obj;
    }
}

