/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.convert.java8;

import hprose.io.convert.Converter;
import hprose.util.DateTime;
import hprose.util.TimeZoneUtil;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class OffsetDateTimeConverter
implements Converter<OffsetDateTime> {
    public static final OffsetDateTimeConverter instance = new OffsetDateTimeConverter();

    public OffsetDateTime convertTo(DateTime dt) {
        return OffsetDateTime.of(dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second, dt.nanosecond, dt.utc ? ZoneOffset.UTC : ZoneOffset.of(TimeZoneUtil.DefaultTZ.getID()));
    }

    @Override
    public OffsetDateTime convertTo(Object obj, Type type) {
        if (obj instanceof DateTime) {
            return this.convertTo((DateTime)obj);
        }
        if (obj instanceof String) {
            return OffsetDateTime.parse((String)obj);
        }
        if (obj instanceof char[]) {
            return OffsetDateTime.parse(new String((char[])obj));
        }
        return (OffsetDateTime)obj;
    }
}

