/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.HproseTcpClient;
import hprose.client.Request;
import hprose.client.Response;
import hprose.client.SocketTransporter;
import hprose.net.Connection;
import hprose.net.TimeoutType;
import hprose.util.concurrent.Promise;
import hprose.util.concurrent.Timer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

final class FullDuplexSocketTransporter
extends SocketTransporter {
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private final Map<Connection, Map<Integer, Response>> responses = new ConcurrentHashMap<Connection, Map<Integer, Response>>();

    public FullDuplexSocketTransporter(HproseTcpClient client) {
        super(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Connection fetch(Request request) {
        Connection conn;
        LinkedList linkedList = this.idleConnections;
        synchronized (linkedList) {
            do {
                if ((conn = (Connection)this.idleConnections.poll()) == null || !conn.isConnected()) continue;
                if (this.responses.get(conn).isEmpty()) {
                    conn.clearTimeout();
                    continue;
                }
                conn = null;
            } while (conn != null && !conn.isConnected());
            if (conn == null) {
                this.create(request);
            }
        }
        return conn;
    }

    private void recycle(Connection conn) {
        conn.setTimeout(this.client.getIdleTimeout(), TimeoutType.IDLE_TIMEOUT);
    }

    private Promise<ByteBuffer> clean(Connection conn, int id) {
        Map<Integer, Response> res = this.responses.get(conn);
        Promise<ByteBuffer> result = null;
        if (res != null) {
            Response response = res.remove(id);
            if (response != null) {
                response.timer.clear();
                result = response.result;
            }
            this.sendNext(conn, res);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNext(Connection conn, Map<Integer, Response> res) {
        if (res.size() < 10) {
            Request request = (Request)this.requests.poll();
            if (request != null) {
                this.send(conn, request);
            } else {
                LinkedList linkedList = this.idleConnections;
                synchronized (linkedList) {
                    if (!this.idleConnections.contains(conn)) {
                        this.idleConnections.offer(conn);
                    }
                }
            }
        }
    }

    @Override
    protected final void send(final Connection conn, Request request) {
        final Map<Integer, Response> res = this.responses.get(conn);
        if (res != null) {
            final int id = nextId.incrementAndGet() & Integer.MAX_VALUE;
            Timer timer = new Timer(new Runnable(){

                @Override
                public void run() {
                    Promise result = FullDuplexSocketTransporter.this.clean(conn, id);
                    if (res.isEmpty()) {
                        FullDuplexSocketTransporter.this.recycle(conn);
                    }
                    if (result != null) {
                        result.reject(new TimeoutException("timeout"));
                    }
                }
            });
            timer.setTimeout(request.timeout);
            res.put(id, new Response(request.result, timer));
            conn.send(request.buffer, id);
            this.sendNext(conn, res);
        }
    }

    @Override
    public final void close() {
        this.close(this.responses.keySet());
    }

    @Override
    public final void onConnect(Connection conn) {
        this.size.incrementAndGet();
        this.responses.put(conn, new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onConnected(Connection conn) {
        Request request = (Request)this.requests.poll();
        if (request != null) {
            this.send(conn, request);
        } else {
            LinkedList linkedList = this.idleConnections;
            synchronized (linkedList) {
                if (!this.idleConnections.contains(conn)) {
                    this.idleConnections.offer(conn);
                }
            }
            this.recycle(conn);
        }
    }

    @Override
    public final void onTimeout(Connection conn, TimeoutType type) {
        block3: {
            Map<Integer, Response> res;
            block2: {
                Request request;
                if (TimeoutType.CONNECT_TIMEOUT != type) break block2;
                this.responses.remove(conn);
                while ((request = (Request)this.requests.poll()) != null) {
                    request.result.reject(new TimeoutException("connect timeout"));
                }
                break block3;
            }
            if (TimeoutType.IDLE_TIMEOUT == type || (res = this.responses.get(conn)) == null) break block3;
            Iterator<Map.Entry<Integer, Response>> it = res.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Response> entry = it.next();
                it.remove();
                Response response = entry.getValue();
                response.timer.clear();
                response.result.reject(new TimeoutException(type.toString()));
            }
        }
    }

    @Override
    public final void onReceived(Connection conn, ByteBuffer data, Integer id) {
        Promise<ByteBuffer> result = this.clean(conn, id);
        if (result != null) {
            if (data.position() != 0) {
                data.flip();
            }
            result.resolve((Object)data);
        } else {
            this.recycle(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onSended(Connection conn, Integer id) {
        LinkedList linkedList = this.idleConnections;
        synchronized (linkedList) {
            if (!this.idleConnections.contains(conn)) {
                this.idleConnections.offer(conn);
            }
        }
    }

    @Override
    public final void onError(Connection conn, Exception e) {
        Map<Integer, Response> res = this.responses.remove(conn);
        if (res != null) {
            Iterator<Map.Entry<Integer, Response>> it = res.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Response> entry = it.next();
                it.remove();
                Response response = entry.getValue();
                response.timer.clear();
                response.result.reject(e);
            }
        }
    }
}

