/*
 * Decompiled with CFR 0.152.
 */
package hprose.net;

import hprose.net.Connection;
import hprose.net.ConnectionHandler;
import hprose.net.ReactorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class Connector
extends Thread {
    protected final AtomicInteger size = new AtomicInteger(0);
    private final Selector selector;
    private final ReactorGroup reactor;
    private final Queue<Connection> queue = new ConcurrentLinkedQueue<Connection>();

    public Connector(int reactorThreads) throws IOException {
        this.selector = Selector.open();
        this.reactor = new ReactorGroup(reactorThreads);
    }

    @Override
    public final void run() {
        this.reactor.start();
        try {
            while (!this.isInterrupted()) {
                try {
                    this.process();
                    this.dispatch();
                }
                catch (IOException iOException) {}
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            // empty catch block
        }
        this.reactor.close();
    }

    public final void close() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void process() {
        Connection conn;
        while ((conn = this.queue.poll()) != null) {
            try {
                conn.connect(this.selector);
            }
            catch (ClosedChannelException e) {
                conn.errorClose();
            }
            catch (IOException e) {
                conn.errorClose();
            }
        }
    }

    private void dispatch() throws IOException {
        int n = this.selector.select();
        if (n == 0) {
            return;
        }
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            if (!key.isConnectable()) continue;
            this.connect(key);
        }
    }

    private void connect(SelectionKey key) {
        SocketChannel channel = (SocketChannel)key.channel();
        Connection conn = (Connection)key.attachment();
        boolean success = false;
        if (channel.isConnectionPending()) {
            try {
                success = channel.finishConnect();
            }
            catch (IOException e) {
                conn.errorClose();
            }
        } else {
            success = true;
        }
        if (success) {
            this.reactor.register(conn);
            key.cancel();
        }
    }

    private void register(Connection conn) {
        this.queue.offer(conn);
        this.selector.wakeup();
    }

    public final void create(String uri, ConnectionHandler handler, boolean keepAlive, boolean noDelay) throws IOException {
        try {
            URI u = new URI(uri);
            SocketChannel channel = SocketChannel.open();
            InetSocketAddress address = new InetSocketAddress(u.getHost(), u.getPort());
            Connection conn = new Connection(channel, handler, address);
            handler.onConnect(conn);
            channel.configureBlocking(false);
            channel.socket().setReuseAddress(true);
            channel.socket().setKeepAlive(keepAlive);
            channel.socket().setTcpNoDelay(noDelay);
            this.register(conn);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
    }
}

