/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.convert;

import hprose.io.convert.BigDecimalConverter;
import hprose.io.convert.BigIntegerConverter;
import hprose.io.convert.BooleanConverter;
import hprose.io.convert.ByteConverter;
import hprose.io.convert.CalendarConverter;
import hprose.io.convert.CharConverter;
import hprose.io.convert.Converter;
import hprose.io.convert.DateConverter;
import hprose.io.convert.DateTimeConverter;
import hprose.io.convert.DoubleConverter;
import hprose.io.convert.FloatConverter;
import hprose.io.convert.HproseDateTimeConverter;
import hprose.io.convert.IntConverter;
import hprose.io.convert.LocaleConverter;
import hprose.io.convert.LongConverter;
import hprose.io.convert.PatternConverter;
import hprose.io.convert.ShortConverter;
import hprose.io.convert.StringBufferConverter;
import hprose.io.convert.StringBuilderConverter;
import hprose.io.convert.StringConverter;
import hprose.io.convert.TimeConverter;
import hprose.io.convert.TimeZoneConverter;
import hprose.io.convert.TimestampConverter;
import hprose.io.convert.URIConverter;
import hprose.io.convert.URLConverter;
import hprose.io.convert.UUIDConverter;
import hprose.util.DateTime;
import hprose.util.JdkVersion;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public final class ConverterFactory {
    private static final ConcurrentHashMap<Class<?>, Converter> converters = new ConcurrentHashMap();

    public static final Converter get(Class<?> type) {
        return converters.get(type);
    }

    public static final void register(Class<?> type, Converter converter) {
        converters.put(type, converter);
    }

    static {
        converters.put(Boolean.TYPE, BooleanConverter.instance);
        converters.put(Character.TYPE, CharConverter.instance);
        converters.put(Byte.TYPE, ByteConverter.instance);
        converters.put(Short.TYPE, ShortConverter.instance);
        converters.put(Integer.TYPE, IntConverter.instance);
        converters.put(Long.TYPE, LongConverter.instance);
        converters.put(Float.TYPE, FloatConverter.instance);
        converters.put(Double.TYPE, DoubleConverter.instance);
        converters.put(Boolean.class, BooleanConverter.instance);
        converters.put(Character.class, CharConverter.instance);
        converters.put(Byte.class, ByteConverter.instance);
        converters.put(Short.class, ShortConverter.instance);
        converters.put(Integer.class, IntConverter.instance);
        converters.put(Long.class, LongConverter.instance);
        converters.put(Float.class, FloatConverter.instance);
        converters.put(Double.class, DoubleConverter.instance);
        converters.put(String.class, StringConverter.instance);
        converters.put(BigInteger.class, BigIntegerConverter.instance);
        converters.put(Date.class, DateConverter.instance);
        converters.put(Time.class, TimeConverter.instance);
        converters.put(Timestamp.class, TimestampConverter.instance);
        converters.put(Date.class, DateTimeConverter.instance);
        converters.put(Calendar.class, CalendarConverter.instance);
        converters.put(BigDecimal.class, BigDecimalConverter.instance);
        converters.put(StringBuilder.class, StringBuilderConverter.instance);
        converters.put(StringBuffer.class, StringBufferConverter.instance);
        converters.put(UUID.class, UUIDConverter.instance);
        converters.put(URL.class, URLConverter.instance);
        converters.put(URI.class, URIConverter.instance);
        converters.put(Locale.class, LocaleConverter.instance);
        converters.put(Pattern.class, PatternConverter.instance);
        converters.put(TimeZone.class, TimeZoneConverter.instance);
        converters.put(DateTime.class, HproseDateTimeConverter.instance);
        if (JdkVersion.majorJavaVersion >= 8) {
            try {
                Class.forName("hprose.io.convert.java8.ConverterLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

