/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.types.Type;

public class ExpressionValue
extends Expression {
    ExpressionValue(Object object, Type type) {
        super(1);
        this.nodes = Expression.emptyArray;
        this.dataType = type;
        this.valueData = object;
    }

    public String getSQL() {
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuffer.append("VALUE = ").append(this.valueData);
                stringBuffer.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuffer.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    Object getValue(Session session, Type type) {
        if (this.dataType == type || this.valueData == null) {
            return this.valueData;
        }
        return type.convertToType(session, this.valueData, this.dataType);
    }

    public Object getValue(Session session) {
        return this.valueData;
    }
}

