/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.index.NodeAVLDisk;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDisk
extends RowAVL {
    public static final int NO_POS = -1;
    int storageSize;
    int keepCount;
    boolean isInMemory;
    int accessCount;
    protected boolean hasDataChanged;
    boolean hasNodesChanged;

    public RowAVLDisk(TableBase tableBase, Object[] objectArray) {
        super(tableBase, objectArray);
        this.setNewNodes();
        this.hasNodesChanged = true;
        this.hasDataChanged = true;
    }

    public RowAVLDisk(TableBase tableBase, RowInputInterface rowInputInterface) throws IOException {
        super(tableBase, null);
        this.position = rowInputInterface.getPos();
        this.storageSize = rowInputInterface.getSize();
        int n = tableBase.getIndexCount();
        NodeAVL nodeAVL = this.nPrimaryNode = new NodeAVLDisk(this, rowInputInterface, 0);
        for (int i = 1; i < n; ++i) {
            nodeAVL = nodeAVL.nNext = new NodeAVLDisk(this, rowInputInterface, i);
        }
        this.rowData = rowInputInterface.readData(this.table.getColumnTypes());
    }

    public NodeAVL insertNode(int n) {
        return null;
    }

    private void readRowInfo(RowInputInterface rowInputInterface) throws IOException {
    }

    public synchronized void setNodesChanged() {
        this.hasNodesChanged = true;
    }

    public void updateAccessCount(int n) {
        this.accessCount = n;
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public int getStorageSize() {
        return this.storageSize;
    }

    public boolean isMemory() {
        return false;
    }

    public void setPos(int n) {
        this.position = n;
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            ((NodeAVLDisk)nodeAVL).iData = this.position;
            nodeAVL = nodeAVL.nNext;
        }
    }

    public synchronized void setChanged() {
        this.hasDataChanged = true;
    }

    public synchronized boolean hasChanged() {
        return this.hasNodesChanged || this.hasDataChanged;
    }

    public TableBase getTable() {
        return this.table;
    }

    public void setStorageSize(int n) {
        this.storageSize = n;
    }

    public synchronized boolean isKeepInMemory() {
        return this.keepCount > 0;
    }

    public void delete(PersistentStore persistentStore) {
        RowAVLDisk rowAVLDisk = this;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(rowAVLDisk, true);
        }
        super.delete(persistentStore);
        rowAVLDisk.keepInMemory(false);
    }

    public void destroy() {
        this.nPrimaryNode = null;
        this.table = null;
    }

    public synchronized boolean keepInMemory(boolean bl) {
        if (!this.isInMemory) {
            return false;
        }
        if (bl) {
            ++this.keepCount;
        } else {
            --this.keepCount;
            if (this.keepCount < 0) {
                throw Error.runtimeError(201, "RowAVLDisk - keep count");
            }
        }
        return true;
    }

    public synchronized boolean isInMemory() {
        return this.isInMemory;
    }

    public synchronized void setInMemory(boolean bl) {
        this.isInMemory = bl;
        if (bl) {
            return;
        }
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            nodeAVL.setInMemory(bl);
            nodeAVL = nodeAVL.nNext;
        }
    }

    public void setNewNodes() {
        int n = this.table.getIndexCount();
        NodeAVL nodeAVL = this.nPrimaryNode = new NodeAVLDisk(this, 0);
        for (int i = 1; i < n; ++i) {
            nodeAVL = nodeAVL.nNext = new NodeAVLDisk(this, i);
        }
    }

    public int getRealSize(RowOutputInterface rowOutputInterface) {
        int n = rowOutputInterface.getSize(this) + this.table.getIndexCount() * 16;
        return n;
    }

    public void write(RowOutputInterface rowOutputInterface) {
        try {
            this.writeNodes(rowOutputInterface);
            if (this.hasDataChanged) {
                rowOutputInterface.writeData(this.rowData, this.table.colTypes);
                rowOutputInterface.writeEnd();
                this.hasDataChanged = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(RowOutputInterface rowOutputInterface, IntLookup intLookup) {
        rowOutputInterface.writeSize(this.storageSize);
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            ((NodeAVLDisk)nodeAVL).write(rowOutputInterface, intLookup);
            nodeAVL = nodeAVL.nNext;
        }
        rowOutputInterface.writeData(this.getData(), this.table.colTypes);
        rowOutputInterface.writeEnd();
    }

    private void writeNodes(RowOutputInterface rowOutputInterface) throws IOException {
        rowOutputInterface.writeSize(this.storageSize);
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            nodeAVL.write(rowOutputInterface);
            nodeAVL = nodeAVL.nNext;
        }
        this.hasNodesChanged = false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RowAVLDisk) {
            return ((RowAVLDisk)object).position == this.position;
        }
        return false;
    }

    public int hashCode() {
        return this.position;
    }
}

