/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Comparator;
import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.SubQuery;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class StatementProcedure
extends StatementDMQL {
    Expression expression;
    Routine procedure;
    Expression[] arguments = Expression.emptyArray;
    ResultMetaData resultMetaData;

    StatementProcedure(Session session, Expression expression, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentSchemaHsqlName());
        this.expression = expression;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (this.procedure != null) {
            session.getGrantee().checkAccess(this.procedure);
        }
    }

    StatementProcedure(Session session, Routine routine, Expression[] expressionArray, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentSchemaHsqlName());
        this.procedure = routine;
        this.arguments = expressionArray;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    Result getResult(Session session) {
        return this.expression == null ? this.getProcedureResult(session) : this.getExpressionResult(session);
    }

    Result getProcedureResult(Session session) {
        Object[] objectArray;
        Object[] objectArray2 = ValuePool.emptyObjectArray;
        if (this.arguments.length > 0) {
            objectArray2 = new Object[this.arguments.length];
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            objectArray = this.arguments[i];
            Object object = objectArray.getValue(session);
            if (objectArray == null) continue;
            Type type = this.procedure.getParameter(i).getDataType();
            objectArray2[i] = type.convertToType(session, object, objectArray.getDataType());
        }
        session.sessionContext.push();
        session.sessionContext.routineArguments = objectArray2;
        session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
        Result result = Result.updateZeroResult;
        result = this.procedure.isPSM() ? this.executePSMProcedure(session) : this.executeJavaProcedure(session);
        objectArray = session.sessionContext.routineArguments;
        session.sessionContext.pop();
        if (result.isError()) {
            return result;
        }
        if (result.isSimpleValue()) {
            result = Result.updateZeroResult;
        }
        boolean bl = false;
        for (int i = 0; i < this.procedure.getParameterCount(); ++i) {
            int n;
            ColumnSchema columnSchema = this.procedure.getParameter(i);
            byte by = columnSchema.getParameterMode();
            if (by == 1) continue;
            if (this.arguments[i].isDynamicParam()) {
                n = this.arguments[i].parameterIndex;
                session.sessionContext.dynamicArguments[n] = objectArray[i];
                bl = true;
                continue;
            }
            n = this.arguments[i].getColumnIndex();
            session.sessionContext.routineVariables[n] = objectArray[i];
        }
        if (bl) {
            result = Result.newCallResponse(this.getParametersMetaData().getParameterTypes(), this.id, session.sessionContext.dynamicArguments);
        }
        return result;
    }

    Result executePSMProcedure(Session session) {
        Result result;
        int n = this.procedure.getVariableCount();
        if (n > 0) {
            session.sessionContext.routineVariables = new Object[n];
        }
        if (!(result = this.procedure.statement.execute(session)).isError()) {
            result = Result.updateZeroResult;
        }
        return result;
    }

    Result executeJavaProcedure(Session session) {
        Result result = Result.updateZeroResult;
        int n = this.procedure.javaMethodWithConnection ? 1 : 0;
        Object[] objectArray = session.sessionContext.routineArguments;
        Object[] objectArray2 = new Object[objectArray.length + n];
        objectArray2 = this.procedure.convertArgsToJava(session, objectArray);
        if (this.procedure.javaMethodWithConnection) {
            objectArray2[0] = session.getInternalConnection();
        }
        result = this.procedure.invokeJavaMethod(session, objectArray2);
        this.procedure.convertArgsToSQL(session, objectArray, objectArray2);
        return result;
    }

    Result getExpressionResult(Session session) {
        session.sessionData.startRowProcessing();
        Object object = this.expression.getValue(session);
        if (object instanceof Result) {
            return (Result)object;
        }
        if (this.resultMetaData == null) {
            this.getResultMetaData();
        }
        Result result = Result.newSingleColumnResult(this.resultMetaData);
        Object[] objectArray = this.expression.getDataType().isArrayType() ? new Object[]{object} : (object instanceof Object[] ? (Object[])object : new Object[]{object});
        result.getNavigator().add(objectArray);
        return result;
    }

    SubQuery[] getSubqueries(Session session) {
        OrderedHashSet orderedHashSet = null;
        if (this.expression != null) {
            orderedHashSet = this.expression.collectAllSubqueries(orderedHashSet);
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            orderedHashSet = this.arguments[i].collectAllSubqueries(orderedHashSet);
        }
        if (orderedHashSet == null || orderedHashSet.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] objectArray = new SubQuery[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        ArraySort.sort(objectArray, 0, objectArray.length, (Comparator)objectArray[0]);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((SubQuery)objectArray[i]).prepareTable(session);
        }
        return objectArray;
    }

    public ResultMetaData getResultMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        switch (this.type) {
            case 7: {
                if (this.expression == null) {
                    return ResultMetaData.emptyResultMetaData;
                }
                ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(1);
                ColumnBase columnBase = new ColumnBase(null, null, null, "@p0");
                columnBase.setType(this.expression.getDataType());
                resultMetaData.columns[0] = columnBase;
                resultMetaData.prepareData();
                this.resultMetaData = resultMetaData;
                return resultMetaData;
            }
        }
        throw Error.runtimeError(201, "StatementProcedure");
    }

    public ResultMetaData getParametersMetaData() {
        return super.getParametersMetaData();
    }

    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        if (this.expression == null) {
            orderedHashSet.addAll(this.procedure.getTableNamesForRead());
        } else {
            int n;
            for (n = 0; n < this.subqueries.length; ++n) {
                if (this.subqueries[n].queryExpression == null) continue;
                this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
            }
            for (n = 0; n < this.routines.length; ++n) {
                orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
            }
        }
    }

    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
        if (this.expression == null) {
            orderedHashSet.addAll(this.procedure.getTableNamesForWrite());
        }
    }
}

