/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Comparator;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.store.BaseHashMap;

public class Cache
extends BaseHashMap {
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private CachedObject[] rowTable;
    long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch sortTimer = new StopWatch(false);
    int saveRowCount = 0;

    Cache(DataFileCache dataFileCache) {
        super(dataFileCache.capacity(), 1, 3, true);
        this.maxCapacity = dataFileCache.capacity();
        this.dataFileCache = dataFileCache;
        this.capacity = dataFileCache.capacity();
        this.bytesCapacity = dataFileCache.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheBytesLength = 0L;
    }

    void init(int n, long l) {
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    public synchronized CachedObject get(int n) {
        int n2;
        if (this.accessCount > 0x7FEFFFFF) {
            this.updateAccessCounts();
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        if ((n2 = this.getLookup(n)) == -1) {
            return null;
        }
        this.accessTable[n2] = ++this.accessCount;
        CachedObject cachedObject = (CachedObject)this.objectValueTable[n2];
        return cachedObject;
    }

    synchronized void put(int n, CachedObject cachedObject) {
        int n2 = cachedObject.getStorageSize();
        if (this.size() >= this.capacity || (long)n2 + this.cacheBytesLength > this.bytesCapacity) {
            this.cleanUp();
        }
        if (this.accessCount > 0x7FEFFFFF) {
            this.updateAccessCounts();
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        super.addOrRemove(n, cachedObject, null, false);
        cachedObject.setInMemory(true);
        this.cacheBytesLength += (long)n2;
    }

    synchronized CachedObject release(int n) {
        CachedObject cachedObject = (CachedObject)super.addOrRemove(n, null, null, true);
        if (cachedObject == null) {
            return null;
        }
        this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        cachedObject.setInMemory(false);
        return cachedObject;
    }

    synchronized void replace(int n, CachedObject cachedObject) {
        int n2 = super.getLookup(n);
        this.objectValueTable[n2] = cachedObject;
    }

    private void updateAccessCounts() {
        for (int i = 0; i < this.objectValueTable.length; ++i) {
            int n;
            CachedObject cachedObject = (CachedObject)this.objectValueTable[i];
            if (cachedObject == null || (n = cachedObject.getAccessCount()) <= this.accessTable[i]) continue;
            this.accessTable[i] = n;
        }
    }

    private void updateObjectAccessCounts() {
        for (int i = 0; i < this.objectValueTable.length; ++i) {
            CachedObject cachedObject = (CachedObject)this.objectValueTable[i];
            if (cachedObject == null) continue;
            int n = this.accessTable[i];
            cachedObject.updateAccessCount(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanUp() {
        this.updateAccessCounts();
        int n = this.size() / 2;
        int n2 = this.getAccessCountCeiling(n, n / 8);
        BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(this);
        int n3 = 0;
        while (baseHashIterator.hasNext()) {
            CachedObject cachedObject = (CachedObject)baseHashIterator.next();
            int n4 = baseHashIterator.getAccessCount();
            if (n4 <= n2) {
                CachedObject cachedObject2 = cachedObject;
                synchronized (cachedObject2) {
                    if (cachedObject.isKeepInMemory()) {
                        baseHashIterator.setAccessCount(n2 + 1);
                    } else {
                        cachedObject.setInMemory(false);
                        if (cachedObject.hasChanged()) {
                            this.rowTable[n3++] = cachedObject;
                        }
                        baseHashIterator.remove();
                        this.cacheBytesLength -= (long)cachedObject.getStorageSize();
                        --n;
                    }
                }
            }
            if (n3 != this.rowTable.length) continue;
            this.saveRows(n3);
            n3 = 0;
        }
        super.setAccessCountFloor(n2);
        this.saveRows(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void forceCleanUp() {
        BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(this);
        while (baseHashIterator.hasNext()) {
            CachedObject cachedObject;
            CachedObject cachedObject2 = cachedObject = (CachedObject)baseHashIterator.next();
            synchronized (cachedObject2) {
                if (!cachedObject.isKeepInMemory()) {
                    cachedObject.setInMemory(false);
                    baseHashIterator.remove();
                    this.cacheBytesLength -= (long)cachedObject.getStorageSize();
                }
            }
        }
    }

    private synchronized void saveRows(int n) {
        if (n == 0) {
            return;
        }
        this.rowComparator.setType(1);
        this.sortTimer.start();
        ArraySort.sort(this.rowTable, 0, n, this.rowComparator);
        this.sortTimer.stop();
        this.saveAllTimer.start();
        this.dataFileCache.saveRows(this.rowTable, 0, n);
        this.saveRowCount += n;
        this.saveAllTimer.stop();
    }

    synchronized void saveAll() {
        BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(this);
        int n = 0;
        while (baseHashIterator.hasNext()) {
            CachedObject cachedObject;
            if (n == this.rowTable.length) {
                this.saveRows(n);
                n = 0;
            }
            if (!(cachedObject = (CachedObject)baseHashIterator.next()).hasChanged()) continue;
            this.rowTable[n++] = cachedObject;
        }
        this.saveRows(n);
        Error.printSystemOut(this.saveAllTimer.elapsedTimeToMessage("Cache.saveRows() total row save time"));
        Error.printSystemOut("Cache.saveRow() total row save count = " + this.saveRowCount);
        Error.printSystemOut(this.sortTimer.elapsedTimeToMessage("Cache.sort() total time"));
    }

    public synchronized void clear() {
        super.clear();
        this.cacheBytesLength = 0L;
    }

    static final class CachedObjectComparator
    implements Comparator {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType;

        CachedObjectComparator() {
        }

        void setType(int n) {
            this.compareType = n;
        }

        public int compare(Object object, Object object2) {
            switch (this.compareType) {
                case 1: {
                    return ((CachedObject)object).getPos() - ((CachedObject)object2).getPos();
                }
                case 2: {
                    return ((CachedObject)object).getStorageSize() - ((CachedObject)object2).getStorageSize();
                }
            }
            return 0;
        }
    }
}

