/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;

public class PersistentStoreCollectionSession
implements PersistentStoreCollection {
    private final Session session;
    private final LongKeyHashMap rowStoreMapSession = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapTransaction = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapStatement = new LongKeyHashMap();

    public PersistentStoreCollectionSession(Session session) {
        this.session = session;
    }

    public void setStore(Object object, PersistentStore persistentStore) {
        TableBase tableBase = (TableBase)object;
        switch (tableBase.persistenceScope) {
            case 21: {
                if (persistentStore == null) {
                    this.rowStoreMapStatement.remove(tableBase.getPersistenceId());
                    break;
                }
                this.rowStoreMapStatement.put(tableBase.getPersistenceId(), persistentStore);
                break;
            }
            case 22: 
            case 24: {
                if (persistentStore == null) {
                    this.rowStoreMapTransaction.remove(tableBase.getPersistenceId());
                    break;
                }
                this.rowStoreMapTransaction.put(tableBase.getPersistenceId(), persistentStore);
                break;
            }
            case 23: {
                if (persistentStore == null) {
                    this.rowStoreMapSession.remove(tableBase.getPersistenceId());
                    break;
                }
                this.rowStoreMapSession.put(tableBase.getPersistenceId(), persistentStore);
                break;
            }
            default: {
                throw Error.runtimeError(201, "PersistentStoreCollectionSession");
            }
        }
    }

    public PersistentStore getStore(Object object) {
        try {
            TableBase tableBase = (TableBase)object;
            switch (tableBase.persistenceScope) {
                case 21: {
                    PersistentStore persistentStore = (PersistentStore)this.rowStoreMapStatement.get(tableBase.getPersistenceId());
                    if (persistentStore == null) {
                        persistentStore = this.session.database.logger.newStore(this.session, this, tableBase, true);
                    }
                    return persistentStore;
                }
                case 22: 
                case 24: {
                    PersistentStore persistentStore = (PersistentStore)this.rowStoreMapTransaction.get(tableBase.getPersistenceId());
                    if (persistentStore == null) {
                        persistentStore = this.session.database.logger.newStore(this.session, this, tableBase, true);
                    }
                    return persistentStore;
                }
                case 23: {
                    PersistentStore persistentStore = (PersistentStore)this.rowStoreMapSession.get(tableBase.getPersistenceId());
                    if (persistentStore == null) {
                        persistentStore = this.session.database.logger.newStore(this.session, this, tableBase, true);
                    }
                    return persistentStore;
                }
            }
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        throw Error.runtimeError(201, "PersistentStoreCollectionSession");
    }

    public void clearAllTables() {
        this.clearSessionTables();
        this.clearTransactionTables();
        this.clearStatementTables();
    }

    public void clearResultTables(long l) {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMapSession.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            if (persistentStore.getTimestamp() != l) continue;
            persistentStore.release();
        }
    }

    public void clearSessionTables() {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMapSession.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            persistentStore.release();
        }
        this.rowStoreMapSession.clear();
    }

    public void clearTransactionTables() {
        if (this.rowStoreMapTransaction.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMapTransaction.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            persistentStore.release();
        }
        this.rowStoreMapTransaction.clear();
    }

    public void clearStatementTables() {
        if (this.rowStoreMapStatement.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMapStatement.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            persistentStore.release();
        }
        this.rowStoreMapStatement.clear();
    }

    public void registerIndex(Table table) {
        PersistentStore persistentStore = this.findStore(table);
        if (persistentStore == null) {
            return;
        }
        persistentStore.resetAccessorKeys(table.getIndexList());
    }

    public PersistentStore findStore(Table table) {
        PersistentStore persistentStore = null;
        switch (table.persistenceScope) {
            case 21: {
                persistentStore = (PersistentStore)this.rowStoreMapStatement.get(table.getPersistenceId());
                break;
            }
            case 22: 
            case 24: {
                persistentStore = (PersistentStore)this.rowStoreMapTransaction.get(table.getPersistenceId());
                break;
            }
            case 23: {
                persistentStore = (PersistentStore)this.rowStoreMapSession.get(table.getPersistenceId());
            }
        }
        return persistentStore;
    }

    public void moveData(Table table, Table table2, int n, int n2) {
        PersistentStore persistentStore = this.findStore(table);
        if (persistentStore == null) {
            return;
        }
        PersistentStore persistentStore2 = this.getStore(table2);
        persistentStore2.moveData(this.session, persistentStore, n, n2);
        this.setStore(table, null);
    }
}

