/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;

public final class UserManager {
    private HashMappedList userList;
    private GranteeManager granteeManager;

    public UserManager(Database database) {
        this.granteeManager = database.getGranteeManager();
        this.userList = new HashMappedList();
    }

    public User createUser(HsqlNameManager.HsqlName hsqlName, String string) {
        User user = this.granteeManager.addUser(hsqlName);
        user.setPassword(string);
        boolean bl = this.userList.add(hsqlName.name, user);
        if (!bl) {
            throw Error.error(4003, hsqlName.statementName);
        }
        return user;
    }

    public void dropUser(String string) {
        boolean bl = GranteeManager.isReserved(string);
        if (bl) {
            throw Error.error(4002, string);
        }
        boolean bl2 = this.granteeManager.removeGrantee(string);
        if (!bl2) {
            throw Error.error(4001, string);
        }
        User user = (User)this.userList.remove(string);
        if (user == null) {
            throw Error.error(4001, string);
        }
    }

    public void createFirstUser(String string, String string2) {
        boolean bl = true;
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
            bl = false;
        }
        HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.nameManager.newHsqlName(string, bl, 11);
        this.createUser(hsqlName, string2);
        this.granteeManager.grant(hsqlName.name, "DBA", this.granteeManager.getDBARole());
    }

    public User getUser(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        User user = this.get(string);
        user.checkPassword(string2);
        return user;
    }

    public HashMappedList getUsers() {
        return this.userList;
    }

    public boolean exists(String string) {
        return this.userList.get(string) != null;
    }

    public User get(String string) {
        User user = (User)this.userList.get(string);
        if (user == null) {
            throw Error.error(4001, string);
        }
        return user;
    }

    public HsqlArrayList listVisibleUsers(Session session) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        boolean bl = session.isAdmin();
        String string = session.getUsername();
        if (this.userList == null || this.userList.size() == 0) {
            return hsqlArrayList;
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            if (user == null) continue;
            String string2 = user.getNameString();
            if (bl) {
                hsqlArrayList.add(user);
                continue;
            }
            if (!string.equals(string2)) continue;
            hsqlArrayList.add(user);
        }
        return hsqlArrayList;
    }

    public User getSysUser() {
        return GranteeManager.systemAuthorisation;
    }

    public synchronized void removeSchemaReference(String string) {
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            HsqlNameManager.HsqlName hsqlName = user.getInitialSchema();
            if (hsqlName == null || !string.equals(hsqlName.name)) continue;
            user.setInitialSchema(null);
        }
    }

    public String[] getInitialSchemaSQL() {
        HsqlArrayList hsqlArrayList = new HsqlArrayList(this.userList.size());
        for (int i = 0; i < this.userList.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName;
            User user = (User)this.userList.get(i);
            if (user.isSystem || (hsqlName = user.getInitialSchema()) == null) continue;
            hsqlArrayList.add(user.getInitialSchemaSQL());
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }
}

