/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.impl.msg;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.htmlunit.cyberneko.xerces.util.MessageFormatter;

public class XMLMessageFormatter
implements MessageFormatter {
    public static final String XML_DOMAIN = "http://www.w3.org/TR/1998/REC-xml-19980210";
    public static final String XMLNS_DOMAIN = "http://www.w3.org/TR/1999/REC-xml-names-19990114";
    private ResourceBundle fResourceBundle = null;

    @Override
    public String formatMessage(String key, Object[] arguments) throws MissingResourceException {
        String msg;
        if (this.fResourceBundle == null) {
            this.fResourceBundle = ResourceBundle.getBundle("org.htmlunit.cyberneko.xerces.impl.msg.XMLMessages");
        }
        try {
            msg = this.fResourceBundle.getString(key);
            if (arguments != null) {
                try {
                    msg = MessageFormat.format(msg, arguments);
                }
                catch (Exception e) {
                    msg = this.fResourceBundle.getString("FormatFailed");
                    msg = msg + " " + this.fResourceBundle.getString(key);
                }
            }
        }
        catch (MissingResourceException e) {
            String msg2 = this.fResourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(key, msg2, key);
        }
        if (msg == null) {
            msg = key;
            if (arguments.length > 0) {
                StringBuilder str = new StringBuilder(msg);
                str.append('?');
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        str.append('&');
                    }
                    str.append(arguments[i]);
                }
                msg = str.toString();
            }
        }
        return msg;
    }
}

