/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.boot.configuration;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.util.AbstractConfigurationFilter;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;

public class SpringSecurityAssertionSessionContextFilter
extends AbstractConfigurationFilter {
    private final AuthenticationUserDetailsService<CasAssertionAuthenticationToken> userDetailsService;
    private final String[] attributes;

    public SpringSecurityAssertionSessionContextFilter(AuthenticationUserDetailsService<CasAssertionAuthenticationToken> userDetailsService, String ... attributes) {
        this.userDetailsService = userDetailsService;
        this.attributes = attributes;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        if (session != null && session.getAttribute("_const_cas_assertion_") != null) {
            Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
            CasAssertionAuthenticationToken token = new CasAssertionAuthenticationToken(assertion, "");
            UserDetails userDetails = this.userDetailsService.loadUserDetails((Authentication)token);
            CasAuthenticationToken authentication = new CasAuthenticationToken("CasAuthenticationToken", (Object)userDetails, (Object)userDetails, userDetails.getAuthorities(), userDetails, assertion);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

