/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.activejdbc.dialects.DefaultDialect;
import org.javalite.activejdbc.dialects.H2Dialect;
import org.javalite.activejdbc.dialects.MSSQLDialect;
import org.javalite.activejdbc.dialects.MySQLDialect;
import org.javalite.activejdbc.dialects.OracleDialect;
import org.javalite.activejdbc.dialects.PostgreSQLDialect;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private Map<String, List<String>> modelsMap = new HashMap<String, List<String>>();
    private Properties properties = new Properties();
    private static CacheManager cacheManager;
    static final Logger logger;
    private Map<String, DefaultDialect> dialects = new HashMap<String, DefaultDialect>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Configuration() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("activejdbc_models.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                LogFilter.log(logger, "Load models from: " + url.toExternalForm());
                InputStream inputStream = null;
                try {
                    String line;
                    inputStream = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((line = reader.readLine()) != null) {
                        String[] parts = Util.split((String)line, (char)':');
                        String modelName = parts[0];
                        String dbName = parts[1];
                        if (this.modelsMap.get(dbName) == null) {
                            this.modelsMap.put(dbName, new ArrayList());
                        }
                        this.modelsMap.get(dbName).add(modelName);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new InitException(e);
        }
        if (this.modelsMap.isEmpty()) {
            LogFilter.log(logger, "ActiveJDBC Warning: Cannot locate any models, assuming project without models.");
            return;
        }
        try {
            InputStream in = this.getClass().getResourceAsStream("/activejdbc.properties");
            if (in != null) {
                this.properties.load(in);
            }
        }
        catch (Exception e) {
            throw new InitException(e);
        }
        String cacheManagerClass = this.properties.getProperty("cache.manager");
        if (cacheManagerClass != null) {
            try {
                Class<?> cmc = Class.forName(cacheManagerClass);
                cacheManager = (CacheManager)cmc.newInstance();
            }
            catch (Exception e) {
                throw new InitException("failed to initialize a CacheManager. Please, ensure that the property 'cache.manager' points to correct class which extends 'activejdbc.cache.CacheManager' class and provides a default constructor.", e);
            }
        }
    }

    List<String> getModelNames(String dbName) throws IOException {
        return this.modelsMap.get(dbName);
    }

    public boolean collectStatistics() {
        return this.properties.getProperty("collectStatistics", "false").equals("true");
    }

    public boolean cacheEnabled() {
        return cacheManager != null;
    }

    DefaultDialect getDialect(MetaModel mm) {
        if (this.dialects.get(mm.getDbType()) == null) {
            if (mm.getDbType().equalsIgnoreCase("Oracle")) {
                this.dialects.put(mm.getDbType(), new OracleDialect());
            } else if (mm.getDbType().equalsIgnoreCase("MySQL")) {
                this.dialects.put(mm.getDbType(), new MySQLDialect());
            } else if (mm.getDbType().equalsIgnoreCase("PostgreSQL")) {
                this.dialects.put(mm.getDbType(), new PostgreSQLDialect());
            } else if (mm.getDbType().equalsIgnoreCase("h2")) {
                this.dialects.put(mm.getDbType(), new H2Dialect());
            } else if (mm.getDbType().equalsIgnoreCase("Microsoft SQL Server")) {
                this.dialects.put(mm.getDbType(), new MSSQLDialect());
            } else {
                this.dialects.put(mm.getDbType(), new DefaultDialect());
            }
        }
        return this.dialects.get(mm.getDbType());
    }

    public CacheManager getCacheManager() {
        return cacheManager;
    }

    static {
        logger = LoggerFactory.getLogger(Configuration.class);
    }
}

