/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.Serializable;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.InternalException;
import org.javalite.activejdbc.LazyList;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.common.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paginator
implements Serializable {
    private int pageSize;
    private String query;
    private String orderBys;
    private Object[] params;
    private MetaModel metaModel;
    private int currentPage;
    private boolean fullQuery;
    private String countQuery;

    public Paginator(Class<? extends Model> modelClass, int pageSize, String query, Object ... params) {
        try {
            Class.forName(modelClass.getName());
        }
        catch (Exception e) {
            throw new InitException(e);
        }
        this.pageSize = pageSize;
        this.query = query;
        this.params = params;
        String tableName = Registry.instance().getTableName(modelClass);
        this.metaModel = Registry.instance().getMetaModel(tableName);
        this.fullQuery = query.trim().toLowerCase().startsWith("select");
        this.countQuery = this.fullQuery ? "SELECT COUNT(*) " + query.substring(query.toLowerCase().indexOf("from")) : "SELECT COUNT(*) FROM " + this.metaModel.getTableName() + " WHERE " + query;
    }

    public Paginator orderBy(String orderBys) {
        this.orderBys = orderBys;
        return this;
    }

    public <T extends Model> LazyList<T> getPage(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("minimum page index == 1");
        }
        try {
            LazyList<T> list = this.find(this.query, this.params);
            int offset = (pageNumber - 1) * this.pageSize;
            list.offset(offset);
            list.limit(this.pageSize);
            if (this.orderBys != null) {
                list.orderBy(this.orderBys);
            }
            this.currentPage = pageNumber;
            return list;
        }
        catch (Exception mustNeverHappen) {
            throw new InternalException(mustNeverHappen);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean getPrevious() {
        return this.hasPrevious();
    }

    public boolean hasPrevious() {
        return this.currentPage > 1 && (long)this.currentPage <= this.pageCount();
    }

    public boolean getNext() {
        return this.hasNext();
    }

    public boolean hasNext() {
        return (long)this.currentPage < this.pageCount();
    }

    public long pageCount() {
        try {
            long results = this.count(this.query, this.params);
            long fullPages = results / (long)this.pageSize;
            return results % (long)this.pageSize == 0L ? fullPages : fullPages + 1L;
        }
        catch (Exception mustNeverHappen) {
            throw new InternalException(mustNeverHappen);
        }
    }

    private <T extends Model> LazyList<T> find(String query, Object ... params) {
        if (query.equals("*") && params.length == 0) {
            return this.findAll();
        }
        if (query.equals("*") && params.length != 0) {
            throw new IllegalArgumentException("cannot provide parameters with query: '*'");
        }
        return this.fullQuery ? new LazyList(true, this.metaModel, this.query, params) : new LazyList(query, params, this.metaModel);
    }

    private <T extends Model> LazyList<T> findAll() {
        return new LazyList(null, new Object[0], this.metaModel);
    }

    private Long count(String query, Object ... params) {
        Long result;
        if (this.metaModel.cached()) {
            result = this.getCount();
            if (result == null) {
                result = this.getCount();
                QueryCache.instance().addItem(this.metaModel.getTableName(), this.countQuery, params, result);
            }
        } else {
            result = this.getCount();
        }
        return result;
    }

    public long getCount() {
        return this.fullQuery ? Convert.toLong((Object)new DB(this.metaModel.getDbName()).firstCell(this.countQuery, this.params)) : new DB(this.metaModel.getDbName()).count(this.metaModel.getTableName(), this.query, this.params);
    }
}

