/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javalite.activejdbc.CallbackListener;
import org.javalite.activejdbc.ColumnMetadata;
import org.javalite.activejdbc.Configuration;
import org.javalite.activejdbc.ConnectionsAccess;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.MetaModels;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.ModelFinder;
import org.javalite.activejdbc.annotations.BelongsTo;
import org.javalite.activejdbc.annotations.BelongsToParents;
import org.javalite.activejdbc.annotations.BelongsToPolymorphic;
import org.javalite.activejdbc.annotations.Cached;
import org.javalite.activejdbc.annotations.IdGenerator;
import org.javalite.activejdbc.annotations.IdName;
import org.javalite.activejdbc.annotations.Many2Many;
import org.javalite.activejdbc.annotations.Table;
import org.javalite.activejdbc.associations.BelongsToAssociation;
import org.javalite.activejdbc.associations.BelongsToPolymorphicAssociation;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.associations.OneToManyAssociation;
import org.javalite.activejdbc.associations.OneToManyPolymorphicAssociation;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.activejdbc.statistics.StatisticsQueue;
import org.javalite.activejdbc.validation.Validator;
import org.javalite.common.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Registry {
    INSTANCE;

    private static final Logger logger;
    private static final HashMap<String, List<Validator>> validators;
    private static final HashMap<Class, List<CallbackListener>> listeners;
    private MetaModels metaModels = new MetaModels();
    private Configuration configuration = new Configuration();
    private StatisticsQueue statisticsQueue;
    private static ModelFinder mf;
    private Set<String> initedDbs = new HashSet<String>();

    private Registry() {
        if (this.configuration.collectStatistics()) {
            this.statisticsQueue = new StatisticsQueue();
        }
    }

    public boolean initialized() {
        return !this.initedDbs.isEmpty();
    }

    public static Registry instance() {
        return INSTANCE;
    }

    public StatisticsQueue getStatisticsQueue() {
        if (this.statisticsQueue == null) {
            throw new InitException("cannot collect statistics if this was not configured in activejdbc.properties file. Add 'collectStatistics = true' to it.");
        }
        return this.statisticsQueue;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static CacheManager cacheManager() {
        return QueryCache.instance().getCacheManager();
    }

    public MetaModel getMetaModel(String table) {
        return this.metaModels.getMetaModel(table);
    }

    public MetaModel getMetaModelByClassName(String className) {
        String dbName;
        try {
            dbName = MetaModel.getDbName(Class.forName(className));
        }
        catch (Exception e) {
            throw new InitException(e);
        }
        this.init(dbName);
        return this.metaModels.getMetaModelByClassName(className);
    }

    public MetaModel getMetaModel(Class<? extends Model> modelClass) {
        String dbName = MetaModel.getDbName(modelClass);
        this.init(dbName);
        return this.metaModels.getMetaModel(modelClass);
    }

    synchronized void init(String dbName) {
        if (this.initedDbs.contains(dbName)) {
            return;
        }
        this.initedDbs.add(dbName);
        try {
            String[] tables;
            mf.findModels(dbName);
            Connection c = ConnectionsAccess.getConnection(dbName);
            if (c == null) {
                throw new DBException("Failed to retrieve metadata from DB, connection: '" + dbName + "' is not available");
            }
            String dbType = c.getMetaData().getDatabaseProductName();
            this.registerModels(dbName, mf.getModelsForDb(dbName), dbType);
            for (String table : tables = this.metaModels.getTableNames(dbName)) {
                Map<String, ColumnMetadata> metaParams = this.fetchMetaParams(table, dbName);
                this.registerColumnMetadata(table, metaParams);
            }
            this.processOverrides(mf.getModelsForDb(dbName));
            for (String table : tables) {
                this.discoverAssociationsFor(table, dbName);
            }
        }
        catch (Exception e) {
            if (e instanceof InitException) {
                throw (InitException)e;
            }
            if (e instanceof DBException) {
                throw (DBException)e;
            }
            throw new InitException(e);
        }
    }

    private void registerModels(String dbName, List<Class<? extends Model>> modelClasses, String dbType) {
        for (Class<? extends Model> modelClass : modelClasses) {
            String idName = this.findIdName(modelClass);
            String tableName = this.findTableName(modelClass);
            String idGeneratorCode = this.findIdGeneratorCode(modelClass);
            MetaModel mm = new MetaModel(dbName, tableName, idName, modelClass, dbType, this.isCached(modelClass), idGeneratorCode);
            this.metaModels.addMetaModel(mm, tableName, modelClass);
            LogFilter.log(logger, "Registered model: " + modelClass);
        }
    }

    private boolean isCached(Class<? extends Model> modelClass) {
        return null != modelClass.getAnnotation(Cached.class);
    }

    private void processOverrides(List<Class<? extends Model>> models) {
        for (Class<? extends Model> modelClass : models) {
            BelongsToPolymorphic belongsToPolymorphic;
            Many2Many many2manyAnnotation;
            BelongsTo belongsToAnnotation = modelClass.getAnnotation(BelongsTo.class);
            this.processOverridesBelongsTo(modelClass, belongsToAnnotation);
            BelongsToParents belongsToParentAnnotation = modelClass.getAnnotation(BelongsToParents.class);
            if (belongsToParentAnnotation != null) {
                for (BelongsTo belongsTo : belongsToParentAnnotation.value()) {
                    this.processOverridesBelongsTo(modelClass, belongsTo);
                }
            }
            if ((many2manyAnnotation = modelClass.getAnnotation(Many2Many.class)) != null) {
                String otherPk;
                String thisPk;
                Class<? extends Model> otherClass = many2manyAnnotation.other();
                String source = this.getTableName(modelClass);
                String target = this.getTableName(otherClass);
                String join = many2manyAnnotation.join();
                String sourceFKName = many2manyAnnotation.sourceFKName();
                String targetFKName = many2manyAnnotation.targetFKName();
                try {
                    Method m = modelClass.getMethod("getMetaModel", new Class[0]);
                    MetaModel mm = (MetaModel)m.invoke(modelClass, new Object[0]);
                    thisPk = mm.getIdName();
                    m = otherClass.getMethod("getMetaModel", new Class[0]);
                    mm = (MetaModel)m.invoke(otherClass, new Object[0]);
                    otherPk = mm.getIdName();
                }
                catch (Exception e) {
                    throw new InitException("failed to determine PK name in many to many relationship", e);
                }
                Many2ManyAssociation many2many1 = new Many2ManyAssociation(source, target, join, sourceFKName, targetFKName, otherPk);
                this.metaModels.getMetaModel(source).addAssociation(many2many1);
                Many2ManyAssociation many2many2 = new Many2ManyAssociation(target, source, join, targetFKName, sourceFKName, thisPk);
                this.metaModels.getMetaModel(target).addAssociation(many2many2);
            }
            if ((belongsToPolymorphic = modelClass.getAnnotation(BelongsToPolymorphic.class)) == null) continue;
            Class<? extends Model>[] parentClasses = belongsToPolymorphic.parents();
            String[] typeLabels = belongsToPolymorphic.typeLabels();
            if (typeLabels.length > 0 && typeLabels.length != parentClasses.length) {
                throw new InitException("must provide all type labels for polymorphic associations");
            }
            int parentClassesLength = parentClasses.length;
            for (int i = 0; i < parentClassesLength; ++i) {
                Class<? extends Model> parentClass = parentClasses[i];
                String typeLabel = typeLabels.length > 0 ? typeLabels[i] : parentClass.getName();
                BelongsToPolymorphicAssociation belongsToPolymorphicAssociation = new BelongsToPolymorphicAssociation(this.getTableName(modelClass), this.getTableName(parentClass), typeLabel, parentClass.getName());
                this.metaModels.getMetaModel(modelClass).addAssociation(belongsToPolymorphicAssociation);
                OneToManyPolymorphicAssociation oneToManyPolymorphicAssociation = new OneToManyPolymorphicAssociation(this.getTableName(parentClass), this.getTableName(modelClass), typeLabel);
                this.metaModels.getMetaModel(parentClass).addAssociation(oneToManyPolymorphicAssociation);
            }
        }
    }

    private void processOverridesBelongsTo(Class<? extends Model> modelClass, BelongsTo belongsToAnnotation) {
        if (belongsToAnnotation != null) {
            Class<? extends Model> parentClass = belongsToAnnotation.parent();
            String foreignKeyName = belongsToAnnotation.foreignKeyName();
            OneToManyAssociation hasMany = new OneToManyAssociation(this.getTableName(parentClass), this.getTableName(modelClass), foreignKeyName);
            BelongsToAssociation belongsTo = new BelongsToAssociation(this.getTableName(modelClass), this.getTableName(parentClass), foreignKeyName);
            this.metaModels.getMetaModel(parentClass).addAssociation(hasMany);
            this.metaModels.getMetaModel(modelClass).addAssociation(belongsTo);
        }
    }

    private Map<String, ColumnMetadata> fetchMetaParams(String table, String dbName) throws SQLException {
        Connection con = ConnectionsAccess.getConnection(dbName);
        String schema = System.getProperty("activejdbc." + dbName + ".schema");
        ResultSet rs = con.getMetaData().getColumns(null, schema, table, null);
        String dbProduct = con.getMetaData().getDatabaseProductName().toLowerCase();
        Map<String, ColumnMetadata> columns = this.getColumns(rs, dbProduct);
        rs.close();
        if (columns.size() == 0) {
            rs = con.getMetaData().getColumns(null, schema, table.toUpperCase(), null);
            dbProduct = con.getMetaData().getDatabaseProductName().toLowerCase();
            columns = this.getColumns(rs, dbProduct);
            rs.close();
        }
        if (columns.size() == 0) {
            rs = con.getMetaData().getColumns(null, schema, table.toLowerCase(), null);
            columns = this.getColumns(rs, dbProduct);
            rs.close();
        }
        if (columns.size() > 0) {
            LogFilter.log(logger, "Fetched metadata for table: " + table);
        } else {
            logger.warn("Failed to retrieve metadata for table: '" + table + "'. Are you sure this table exists? For some databases table names are case sensitive.");
        }
        return columns;
    }

    private Map<String, ColumnMetadata> getColumns(ResultSet rs, String dbProduct) throws SQLException {
        HashMap<String, ColumnMetadata> columns = new HashMap<String, ColumnMetadata>();
        while (rs.next()) {
            if (dbProduct.equals("h2") && "INFORMATION_SCHEMA".equals(rs.getString("TABLE_SCHEMA"))) continue;
            ColumnMetadata cm = new ColumnMetadata(rs.getString("COLUMN_NAME").toLowerCase(), rs.getString("TYPE_NAME"), rs.getInt("COLUMN_SIZE"));
            columns.put(cm.getColumnName(), cm);
        }
        return columns;
    }

    private void discoverAssociationsFor(String source, String dbName) {
        this.discoverOne2ManyAssociationsFor(source, dbName);
        this.discoverMany2ManyAssociationsFor(source, dbName);
    }

    private void discoverMany2ManyAssociationsFor(String source, String dbName) {
        for (String join : this.metaModels.getTableNames(dbName)) {
            String other = Inflector.getOtherName((String)source, (String)join);
            if (other == null || this.getMetaModel(other) == null || !this.hasForeignKeys(join, source, other)) continue;
            Many2ManyAssociation associationSource = new Many2ManyAssociation(source, other, join, this.getMetaModel(source).getFKName(), this.getMetaModel(other).getFKName());
            this.getMetaModel(source).addAssociation(associationSource);
        }
    }

    private boolean hasForeignKeys(String join, String source, String other) {
        String sourceFKName = this.getMetaModel(source).getFKName();
        String otherFKName = this.getMetaModel(other).getFKName();
        MetaModel joinMM = this.getMetaModel(join);
        return joinMM.hasAttribute(sourceFKName) && joinMM.hasAttribute(otherFKName);
    }

    private void discoverOne2ManyAssociationsFor(String source, String dbName) {
        MetaModel sourceMM = this.getMetaModel(source);
        for (String target : this.metaModels.getTableNames(dbName)) {
            MetaModel targetMM = this.getMetaModel(target);
            String sourceFKName = this.getMetaModel(source).getFKName();
            if (targetMM == sourceMM || !targetMM.hasAttribute(sourceFKName)) continue;
            targetMM.addAssociation(new BelongsToAssociation(target, source, sourceFKName));
            sourceMM.addAssociation(new OneToManyAssociation(source, target, sourceFKName));
        }
    }

    private String findIdGeneratorCode(Class<? extends Model> modelClass) {
        IdGenerator idGenerator = modelClass.getAnnotation(IdGenerator.class);
        return idGenerator == null ? null : idGenerator.value();
    }

    private String findIdName(Class<? extends Model> modelClass) {
        IdName idNameAnnotation = modelClass.getAnnotation(IdName.class);
        return idNameAnnotation == null ? "id" : idNameAnnotation.value();
    }

    private String findTableName(Class<? extends Model> modelClass) {
        Table tableAnnotation = modelClass.getAnnotation(Table.class);
        return tableAnnotation == null ? Inflector.tableize((String)Inflector.shortName((String)modelClass.getName())) : tableAnnotation.value();
    }

    protected Class<? extends Model> getModelClass(String table, boolean suppressException) {
        Class modelClass = this.metaModels.getModelClass(table);
        if (modelClass == null && !suppressException) {
            throw new InitException("failed to locate meta model for: " + table + ", are you sure this is correct table name?");
        }
        return modelClass;
    }

    protected String getTableName(Class<? extends Model> modelClass) {
        this.init(MetaModel.getDbName(modelClass));
        String tableName = this.metaModels.getTableName(modelClass);
        if (tableName == null) {
            throw new DBException("failed to find metamodel for " + modelClass + ". Are you sure that a corresponding table  exists in DB?");
        }
        return tableName;
    }

    protected List<Validator> getValidators(String daClass) {
        List<Validator> validatorList = validators.get(daClass);
        if (validatorList == null) {
            validatorList = new ArrayList<Validator>();
            validators.put(daClass, validatorList);
        }
        return validatorList;
    }

    @Deprecated
    public void addValidators(Class<? extends Model> daClass, List<? extends Validator> modelValidators) {
        this.getValidators(daClass.getName()).addAll(modelValidators);
    }

    public void addValidators(String daClass, List<? extends Validator> modelValidators) {
        this.getValidators(daClass).addAll(modelValidators);
    }

    public void removeValidator(Class<Model> daClass, Validator validator) {
        this.getValidators(daClass.getName()).remove(validator);
    }

    protected List<String> getEdges(String join) {
        return this.metaModels.getEdges(join);
    }

    private void registerColumnMetadata(String table, Map<String, ColumnMetadata> metaParams) {
        this.metaModels.setColumnMetadata(table, metaParams);
    }

    protected List<CallbackListener> getListeners(Class modelClass) {
        if (listeners.get(modelClass) == null) {
            listeners.put(modelClass, new ArrayList());
        }
        return listeners.get(modelClass);
    }

    public void addListener(Class modelClass, CallbackListener listener) {
        this.getListeners(modelClass).add(listener);
    }

    static {
        logger = LoggerFactory.getLogger(Registry.class);
        validators = new HashMap();
        listeners = new HashMap();
        mf = new ModelFinder();
    }
}

