/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import java.util.ArrayList;
import java.util.List;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheManager {
    private static final Logger logger = LoggerFactory.getLogger(CacheManager.class);
    List<CacheEventListener> listeners = new ArrayList<CacheEventListener>();

    public abstract Object getCache(String var1, String var2);

    public abstract void addCache(String var1, String var2, Object var3);

    public abstract void doFlush(CacheEvent var1);

    public final void flush(CacheEvent event) {
        this.doFlush(event);
        for (CacheEventListener listener : this.listeners) {
            try {
                listener.onFlush(event);
            }
            catch (Throwable e) {
                logger.warn("failed to propagate cache event: " + event + "  to listener: " + listener, e);
            }
        }
        String message = event.getType() == CacheEvent.CacheEventType.ALL ? "all caches" : "table: " + event.getGroup();
        LogFilter.log(logger, "Cache purged: " + message);
    }

    public final void addCacheEventListener(CacheEventListener listener) {
        this.listeners.add(listener);
    }

    public final void removeCacheEventListener(CacheEventListener listener) {
        this.listeners.remove(listener);
    }

    public final void removeAllCacheEventListeners() {
        this.listeners = new ArrayList<CacheEventListener>();
    }
}

