/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheManager;

public class OSCacheManager
extends CacheManager {
    private GeneralCacheAdministrator administrator = new GeneralCacheAdministrator();

    public Object getCache(String group, String key) {
        try {
            return this.administrator.getFromCache(key);
        }
        catch (NeedsRefreshException nre) {
            try {
                this.administrator.cancelUpdate(key);
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }
    }

    public void addCache(String group, String key, Object cache) {
        try {
            this.administrator.putInCache(key, cache, new String[]{group});
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    public void doFlush(CacheEvent event) {
        if (event.getType().equals((Object)CacheEvent.CacheEventType.ALL)) {
            this.administrator.flushAll();
        } else if (event.getType().equals((Object)CacheEvent.CacheEventType.GROUP)) {
            this.administrator.flushGroup(event.getGroup());
        }
    }
}

