/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.util.List;
import org.javalite.activejdbc.dialects.DefaultDialect;
import org.javalite.common.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDialect
extends DefaultDialect {
    @Override
    public String formSelect(String tableName, String subQuery, List<String> orderBys, long limit, long offset) {
        String tmp;
        String fullQuery;
        boolean needLimit = limit != -1L;
        boolean needOffset = offset != -1L;
        ++offset;
        if (tableName == null) {
            fullQuery = subQuery;
        } else {
            String string = fullQuery = needLimit || needOffset ? "SELECT t.* FROM " + tableName + " t " : "SELECT * FROM " + tableName;
            if (!Util.blank((Object)subQuery)) {
                String where = " WHERE ";
                if (!this.groupByPattern.matcher(subQuery.toLowerCase().trim()).find() && !this.orderByPattern.matcher(subQuery.toLowerCase().trim()).find()) {
                    fullQuery = fullQuery + where;
                }
                fullQuery = fullQuery + subQuery;
            }
        }
        if (orderBys.size() != 0) {
            fullQuery = fullQuery + " ORDER BY " + Util.join(orderBys, (String)", ");
        }
        if (needLimit && needOffset) {
            tmp = "SELECT * FROM ( SELECT t2.*, ROWNUM as ORACLE_ROW_NUMBER FROM ( " + fullQuery + " ) t2) WHERE ";
            fullQuery = tmp + "ORACLE_ROW_NUMBER >= " + offset + " AND ROWNUM <= " + limit;
        } else if (needLimit && !needOffset) {
            tmp = "SELECT * FROM ( SELECT t2.* FROM ( " + fullQuery + " ) t2) WHERE ";
            fullQuery = tmp + "ROWNUM <= " + limit;
        } else if (needOffset) {
            tmp = "SELECT * FROM ( SELECT t2.*, ROWNUM as ORACLE_ROW_NUMBER FROM ( " + fullQuery + " ) t2) WHERE ";
            fullQuery = tmp + "ORACLE_ROW_NUMBER >= " + offset;
        }
        return fullQuery;
    }
}

