/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.validation;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.javalite.activejdbc.Messages;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.validation.Converter;
import org.javalite.common.Util;

public class TimestampConverter
extends Converter {
    private String attributeName;
    private String message;
    private String format;
    private SimpleDateFormat df;

    public TimestampConverter(String attributeName, String format) {
        this.attributeName = attributeName;
        this.message = "attribute {0} does not conform to format: {1}";
        this.df = new SimpleDateFormat(format);
        this.format = format;
    }

    public void convert(Model m) {
        Object val = m.get(this.attributeName);
        if (!Util.blank((Object)val) && !(val instanceof Timestamp)) {
            try {
                long time = this.df.parse(val.toString()).getTime();
                Timestamp t = new Timestamp(time);
                m.set(this.attributeName, (Object)t);
            }
            catch (Exception e) {
                m.addValidator(this, this.attributeName);
            }
        }
    }

    public String formatMessage(Locale locale, Object ... params) {
        return locale != null ? Messages.message(this.message, locale, this.attributeName, this.format) : Messages.message(this.message, this.attributeName, this.format);
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

