/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.javalite.common.Util;
import org.javalite.http.HttpException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Request<T extends Request> {
    protected HttpURLConnection connection;
    private boolean connected;
    protected String url;

    public Request(String url, int connectTimeout, int readTimeout) {
        try {
            this.url = url;
            this.connection = (HttpURLConnection)new URL(url).openConnection();
            this.connection.setConnectTimeout(connectTimeout);
            this.connection.setReadTimeout(readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public T header(String name, String value) {
        this.connection.setRequestProperty(name, value);
        return (T)this;
    }

    public InputStream getInputStream() {
        try {
            return this.connection.getInputStream();
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    public Map<String, List<String>> headers() {
        this.connect();
        return this.connection.getHeaderFields();
    }

    public int responseCode() {
        try {
            this.connect();
            return this.connection.getResponseCode();
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    public String responseMessage() {
        try {
            this.connect();
            return this.connection.getResponseMessage();
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    public byte[] bytes() {
        this.connect();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        try {
            int count;
            InputStream in = this.connection.getInputStream();
            while ((count = in.read(bytes)) != -1) {
                bout.write(bytes, 0, count);
            }
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
        this.dispose();
        return bout.toByteArray();
    }

    public String text() {
        try {
            this.connect();
            String result = this.responseCode() >= 400 ? Util.read(this.connection.getErrorStream()) : Util.read(this.connection.getInputStream());
            this.dispose();
            return result;
        }
        catch (IOException e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    public String text(String encoding) {
        try {
            this.connect();
            String result = this.responseCode() >= 400 ? Util.read(this.connection.getErrorStream()) : Util.read(this.connection.getInputStream(), encoding);
            this.dispose();
            return result;
        }
        catch (IOException e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    public void dispose() {
        byte[] bytes = new byte[1024];
        try {
            int count = 0;
            InputStream in = this.connection.getInputStream();
            while ((count = in.read(bytes)) > 0) {
            }
            in.close();
        }
        catch (Exception ignore) {
            try {
                InputStream errorStream = this.connection.getErrorStream();
                int ret = 0;
                while ((ret = errorStream.read(bytes)) > 0) {
                }
                errorStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected T connect() {
        if (!this.connected) {
            T t = this.doConnect();
            this.connected = true;
            return t;
        }
        return (T)this;
    }

    protected abstract T doConnect();

    public T basic(String user, String password) {
        Authenticator.setDefault(new BasicAuthenticator(user, password));
        return (T)this;
    }

    class BasicAuthenticator
    extends Authenticator {
        private String user;
        private String password;

        BasicAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

