/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.logging;

import java.util.logging.Level;
import org.javasimon.Split;
import org.javasimon.callback.logging.CounterLogTemplate;
import org.javasimon.callback.logging.DisabledLogTemplate;
import org.javasimon.callback.logging.JULLogTemplate;
import org.javasimon.callback.logging.LogTemplate;
import org.javasimon.callback.logging.PeriodicLogTemplate;
import org.javasimon.callback.logging.SLF4JLogTemplate;
import org.javasimon.callback.logging.SplitThresholdLogTemplate;
import org.javasimon.clock.SimonClock;

public class LogTemplates {
    public static <C> LogTemplate<C> disabled() {
        return DisabledLogTemplate.getInstance();
    }

    public static <C> LogTemplate<C> everyNSplits(LogTemplate<C> delegateLogger, int period) {
        return new CounterLogTemplate(delegateLogger, period);
    }

    public static <C> LogTemplate<C> everyNMilliseconds(LogTemplate<C> delegateLogger, long period) {
        return new PeriodicLogTemplate<C>(delegateLogger, period);
    }

    static <C> LogTemplate<C> everyNMilliseconds(LogTemplate<C> delegateLogger, long period, SimonClock clock) {
        return new PeriodicLogTemplate<C>(delegateLogger, period, clock);
    }

    public static <C> LogTemplate<C> everyNSeconds(LogTemplate<C> delegateLogger, long period) {
        return LogTemplates.everyNMilliseconds(delegateLogger, period * 1000L);
    }

    public static <C> SLF4JLogTemplate<C> toSLF4J(String loggerName, String levelName, String markerName) {
        if ("debug".equals(levelName = levelName.toLowerCase())) {
            return new SLF4JLogTemplate.Debug(loggerName, markerName);
        }
        if ("info".equals(levelName)) {
            return new SLF4JLogTemplate.Info(loggerName, markerName);
        }
        if ("warn".equals(levelName)) {
            return new SLF4JLogTemplate.Warn(loggerName, markerName);
        }
        throw new IllegalArgumentException("Invalid level name " + levelName);
    }

    public static <C> SLF4JLogTemplate<C> toSLF4J(String loggerName, String levelName) {
        return LogTemplates.toSLF4J(loggerName, levelName, null);
    }

    public static <C> JULLogTemplate<C> toJUL(String loggerName, Level level) {
        return new JULLogTemplate(loggerName, level);
    }

    public static SplitThresholdLogTemplate whenSplitLongerThanNanoseconds(LogTemplate<Split> delegateLogger, long threshold) {
        return new SplitThresholdLogTemplate(delegateLogger, threshold);
    }

    public static SplitThresholdLogTemplate whenSplitLongerThanMilliseconds(LogTemplate<Split> delegateLogger, long threshold) {
        return LogTemplates.whenSplitLongerThanNanoseconds(delegateLogger, threshold * SimonClock.NANOS_IN_MILLIS);
    }
}

