/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimonConnectionConfiguration {
    public static final String DEFAULT_PREFIX = "org.javasimon.jdbc";
    public static final String URL_PREFIX = "jdbc:simon";
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:(simon:)?([\\w]*):.*");
    public static final String REAL_DRIVER = "simon_real_drv";
    public static final String PREFIX = "simon_prefix";
    private static final Properties PROPERTIES = SimonConnectionConfiguration.initProperties();
    private final String simonUrl;
    private final String realUrl;
    private final String driverId;
    private final String realDriver;
    private final String prefix;

    private static Properties initProperties() {
        InputStream stream = null;
        try {
            Properties properties = new Properties();
            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/javasimon/jdbc4/drivers.properties");
            if (stream != null) {
                properties.load(stream);
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public SimonConnectionConfiguration(String url) {
        Matcher m = URL_PATTERN.matcher(url);
        if (!m.matches()) {
            throw new IllegalArgumentException(url + " is not a valid JDBC connection URL");
        }
        this.driverId = m.group(2);
        if (m.group(1) == null) {
            this.simonUrl = url.replaceFirst("jdbc", URL_PREFIX);
            this.realUrl = url;
            this.realDriver = SimonConnectionConfiguration.getProperty(this.driverId, "driver");
            this.prefix = DEFAULT_PREFIX;
        } else {
            this.simonUrl = url;
            StringTokenizer st = new StringTokenizer(url, ";");
            String lRealDriver = SimonConnectionConfiguration.getProperty(this.driverId, "driver");
            String lPrefix = DEFAULT_PREFIX;
            StringBuilder realUrlBuilder = new StringBuilder();
            while (st.hasMoreTokens()) {
                String tokenValue;
                String tokenPairStr = st.nextToken().trim();
                if (tokenPairStr.startsWith(URL_PREFIX)) {
                    realUrlBuilder.append(tokenPairStr.replaceFirst(URL_PREFIX, "jdbc"));
                    continue;
                }
                String[] tokenPair = tokenPairStr.split("=", 2);
                String token = tokenPair[0];
                String string = tokenValue = tokenPair.length == 2 ? tokenPair[1].trim() : null;
                if (token.equalsIgnoreCase(REAL_DRIVER)) {
                    lRealDriver = tokenValue;
                    continue;
                }
                if (token.equalsIgnoreCase(PREFIX)) {
                    lPrefix = tokenValue;
                    continue;
                }
                realUrlBuilder.append(';').append(tokenPairStr);
            }
            this.realUrl = realUrlBuilder.toString();
            this.realDriver = lRealDriver;
            this.prefix = lPrefix;
        }
    }

    private static String getProperty(String driverId, String propertyName) {
        String propertyValue = PROPERTIES.getProperty("org.javasimon.jdbc." + driverId + "." + propertyName);
        if (propertyValue != null && (propertyValue = propertyValue.trim()).isEmpty()) {
            propertyValue = null;
        }
        return propertyValue;
    }

    public String getRealUrl() {
        return this.realUrl;
    }

    public String getDriverId() {
        return this.driverId;
    }

    public String getRealDriver() {
        return this.realDriver;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSimonUrl() {
        return this.simonUrl;
    }

    public static boolean isSimonUrl(String url) {
        return url != null && url.toLowerCase().startsWith(URL_PREFIX);
    }

    public String getRealConnectionPoolDataSourceName() {
        return SimonConnectionConfiguration.getProperty(this.driverId, "cpdatasource");
    }

    public String getRealDataSourceName() {
        return SimonConnectionConfiguration.getProperty(this.driverId, "datasource");
    }

    public String getRealXADataSourceName() {
        return SimonConnectionConfiguration.getProperty(this.driverId, "xadatasource");
    }
}

