/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.resteasy.plugins.server.netty.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpResponse;

public class NettyHttpResponse
implements HttpResponse {
    private int status = 200;
    private ChannelBufferOutputStream underlyingOutputStream;
    private OutputStream os;
    private MultivaluedMap<String, Object> outputHeaders = new MultivaluedMapImpl();
    private final Channel channel;
    private boolean committed;
    private boolean keepAlive;
    private HttpMethod method;

    public NettyHttpResponse(Channel channel, boolean keepAlive) {
        this(channel, keepAlive, null);
    }

    public NettyHttpResponse(Channel channel, boolean keepAlive, HttpMethod method) {
        this.underlyingOutputStream = new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer());
        this.os = this.underlyingOutputStream;
        this.channel = channel;
        this.keepAlive = keepAlive;
        this.method = method;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public ChannelBuffer getBuffer() {
        return this.underlyingOutputStream.buffer();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        if (this.committed) {
            throw new IllegalStateException();
        }
        HttpResponseStatus responseStatus = null;
        responseStatus = message != null ? new HttpResponseStatus(status, message) : HttpResponseStatus.valueOf((int)status);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, responseStatus);
        if (this.keepAlive) {
            response.addHeader("Connection", (Object)"keep-alive");
            response.addHeader("Content-Length", (Object)0);
        }
        this.channel.write((Object)response);
        this.committed = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException(Messages.MESSAGES.alreadyCommitted());
        }
        this.outputHeaders.clear();
        this.underlyingOutputStream.buffer().clear();
        this.outputHeaders.clear();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpMethod getMethod() {
        return this.method;
    }
}

