/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import org.jeecgframework.poi.excel.annotation.ExcelEntity;
import org.jeecgframework.poi.excel.annotation.ExcelIgnore;
import org.jeecgframework.poi.word.entity.WordImageEntity;
import org.jeecgframework.poi.word.entity.params.ExcelListEntity;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public final class PoiPublicUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiPublicUtil.class);

    private PoiPublicUtil() {
    }

    public static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    public static Object createObject(Class<?> clazz, String targetId) {
        Object obj = null;
        try {
            Field[] fields;
            if (clazz.equals(Map.class)) {
                return new HashMap();
            }
            obj = clazz.newInstance();
            for (Field field : fields = PoiPublicUtil.getClassFields(clazz)) {
                Method setMethod;
                if (PoiPublicUtil.isNotUserExcelUserThis(null, field, targetId)) continue;
                if (PoiPublicUtil.isCollection(field.getType())) {
                    ExcelCollection collection = field.getAnnotation(ExcelCollection.class);
                    setMethod = PoiPublicUtil.getMethod(field.getName(), clazz, field.getType());
                    setMethod.invoke(obj, collection.type().newInstance());
                    continue;
                }
                if (PoiPublicUtil.isJavaClass(field)) continue;
                setMethod = PoiPublicUtil.getMethod(field.getName(), clazz, field.getType());
                setMethod.invoke(obj, PoiPublicUtil.createObject(field.getType(), targetId));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u521b\u5efa\u5bf9\u8c61\u5f02\u5e38");
        }
        return obj;
    }

    public static Field[] getClassFields(Class<?> clazz) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                list.add(fields[i]);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null);
        return list.toArray(fields);
    }

    public static String getFileExtendName(byte[] photoByte) {
        String strFileExtendName = "JPG";
        if (photoByte[0] == 71 && photoByte[1] == 73 && photoByte[2] == 70 && photoByte[3] == 56 && (photoByte[4] == 55 || photoByte[4] == 57) && photoByte[5] == 97) {
            strFileExtendName = "GIF";
        } else if (photoByte[6] == 74 && photoByte[7] == 70 && photoByte[8] == 73 && photoByte[9] == 70) {
            strFileExtendName = "JPG";
        } else if (photoByte[0] == 66 && photoByte[1] == 77) {
            strFileExtendName = "BMP";
        } else if (photoByte[1] == 80 && photoByte[2] == 78 && photoByte[3] == 71) {
            strFileExtendName = "PNG";
        }
        return strFileExtendName;
    }

    public static Method getMethod(String name, Class<?> pojoClass) throws Exception {
        StringBuffer getMethodName = new StringBuffer("get");
        getMethodName.append(name.substring(0, 1).toUpperCase());
        getMethodName.append(name.substring(1));
        Method method = null;
        try {
            method = pojoClass.getMethod(getMethodName.toString(), new Class[0]);
        }
        catch (Exception e) {
            method = pojoClass.getMethod(getMethodName.toString().replace("get", "is"), new Class[0]);
        }
        return method;
    }

    public static Method getMethod(String name, Class<?> pojoClass, Class<?> type) throws Exception {
        StringBuffer getMethodName = new StringBuffer("set");
        getMethodName.append(name.substring(0, 1).toUpperCase());
        getMethodName.append(name.substring(1));
        return pojoClass.getMethod(getMethodName.toString(), type);
    }

    public static Method getMethod(String name, Class<?> pojoClass, boolean convert) throws Exception {
        StringBuffer getMethodName = new StringBuffer();
        if (convert) {
            getMethodName.append("convert");
        }
        getMethodName.append("get");
        getMethodName.append(name.substring(0, 1).toUpperCase());
        getMethodName.append(name.substring(1));
        Method method = null;
        try {
            method = pojoClass.getMethod(getMethodName.toString(), new Class[0]);
        }
        catch (Exception e) {
            method = pojoClass.getMethod(getMethodName.toString().replace("get", "is"), new Class[0]);
        }
        return method;
    }

    public static Method getMethod(String name, Class<?> pojoClass, Class<?> type, boolean convert) throws Exception {
        StringBuffer setMethodName = new StringBuffer();
        if (convert) {
            setMethodName.append("convert");
        }
        setMethodName.append("set");
        setMethodName.append(name.substring(0, 1).toUpperCase());
        setMethodName.append(name.substring(1));
        return pojoClass.getMethod(setMethodName.toString(), type);
    }

    public static Map<String, PictureData> getSheetPictrues03(HSSFSheet sheet, HSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (!pictures.isEmpty()) {
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                if (!(shape instanceof HSSFPicture)) continue;
                HSSFPicture pic = (HSSFPicture)shape;
                int pictureIndex = pic.getPictureIndex() - 1;
                HSSFPictureData picData = (HSSFPictureData)pictures.get(pictureIndex);
                String picIndex = String.valueOf(anchor.getRow1()) + "_" + String.valueOf(anchor.getCol1());
                sheetIndexPicMap.put(picIndex, (PictureData)picData);
            }
            return sheetIndexPicMap;
        }
        return null;
    }

    public static Map<String, PictureData> getSheetPictrues07(XSSFSheet sheet, XSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture pic = (XSSFPicture)shape;
                XSSFClientAnchor anchor = pic.getPreferredSize();
                CTMarker ctMarker = anchor.getFrom();
                String picIndex = ctMarker.getRow() + "_" + ctMarker.getCol();
                sheetIndexPicMap.put(picIndex, (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }

    public static String getWebRootPath(String filePath) {
        String path = ClassUtils.getDefaultClassLoader().getResource("").getPath();
        LOGGER.debug("--- getWebRootPath ----filePath--- " + path);
        path = path.replace("WEB-INF/classes/", "");
        path = path.replace("file:/", "");
        LOGGER.debug("--- path---  " + path);
        LOGGER.debug("--- filePath---  " + filePath);
        return path + filePath;
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isJavaClass(Field field) {
        Class<?> fieldType = field.getType();
        boolean isBaseClass = false;
        if (fieldType.isArray()) {
            isBaseClass = false;
        } else if (fieldType.isPrimitive() || fieldType.getPackage() == null || fieldType.getPackage().getName().equals("java.lang") || fieldType.getPackage().getName().equals("java.math") || fieldType.getPackage().getName().equals("java.sql") || fieldType.getPackage().getName().equals("java.util")) {
            isBaseClass = true;
        }
        return isBaseClass;
    }

    public static boolean isNotUserExcelUserThis(List<String> exclusionsList, Field field, String targetId) {
        boolean boo = true;
        if (field.getAnnotation(ExcelIgnore.class) != null) {
            boo = true;
        } else if (boo && field.getAnnotation(ExcelCollection.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(ExcelCollection.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(ExcelCollection.class).name()))) {
            boo = false;
        } else if (boo && field.getAnnotation(Excel.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(Excel.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(Excel.class).name()))) {
            boo = false;
        } else if (boo && field.getAnnotation(ExcelEntity.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(ExcelEntity.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(ExcelEntity.class).name()))) {
            boo = false;
        }
        return boo;
    }

    private static boolean isUseInThis(String exportName, String targetId) {
        return targetId == null || exportName.equals("") || exportName.indexOf("_") < 0 || exportName.indexOf(targetId) != -1;
    }

    private static Integer getImageType(String type) {
        if (type.equalsIgnoreCase("JPG") || type.equalsIgnoreCase("JPEG")) {
            return 5;
        }
        if (type.equalsIgnoreCase("GIF")) {
            return 8;
        }
        if (type.equalsIgnoreCase("BMP")) {
            return 8;
        }
        if (type.equalsIgnoreCase("PNG")) {
            return 6;
        }
        return 5;
    }

    public static Object[] getIsAndType(WordImageEntity entity) throws Exception {
        String type;
        Object[] result = new Object[2];
        if (entity.getType().equals(WordImageEntity.URL)) {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            String path = Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath() + entity.getUrl();
            path = path.replace("WEB-INF/classes/", "");
            path = path.replace("file:/", "");
            BufferedImage bufferImg = ImageIO.read(new File(path));
            ImageIO.write((RenderedImage)bufferImg, entity.getUrl().substring(entity.getUrl().indexOf(".") + 1, entity.getUrl().length()), byteArrayOut);
            result[0] = byteArrayOut.toByteArray();
            type = entity.getUrl().split("/.")[entity.getUrl().split("/.").length - 1];
        } else {
            result[0] = entity.getData();
            type = PoiPublicUtil.getFileExtendName(entity.getData());
        }
        result[1] = PoiPublicUtil.getImageType(type);
        return result;
    }

    public static Object getParamsValue(String params, Object object) throws Exception {
        if (params.indexOf(".") != -1) {
            String[] paramsArr = params.split("\\.");
            return PoiPublicUtil.getValueDoWhile(object, paramsArr, 0);
        }
        if (object instanceof Map) {
            return ((Map)object).get(params);
        }
        return PoiPublicUtil.getMethod(params, object.getClass()).invoke(object, new Object[0]);
    }

    public static Object getRealValue(String currentText, Map<String, Object> map) throws Exception {
        String params = "";
        while (currentText.indexOf("{{") != -1) {
            params = currentText.substring(currentText.indexOf("{{") + 2, currentText.indexOf("}}"));
            Object obj = PoiPublicUtil.getParamsValue(params.trim(), map);
            if (obj instanceof WordImageEntity || obj instanceof List || obj instanceof ExcelListEntity) {
                return obj;
            }
            currentText = currentText.replace("{{" + params + "}}", obj.toString());
        }
        return currentText;
    }

    public static Object getValueDoWhile(Object object, String[] paramsArr, int index) throws Exception {
        if (object == null) {
            return "";
        }
        if (object instanceof WordImageEntity) {
            return object;
        }
        object = object instanceof Map ? ((Map)object).get(paramsArr[index]) : PoiPublicUtil.getMethod(paramsArr[index], object.getClass()).invoke(object, new Object[0]);
        return index == paramsArr.length - 1 ? (object == null ? "" : object) : PoiPublicUtil.getValueDoWhile(object, paramsArr, ++index);
    }

    public static String doubleToString(Double value) {
        String temp = value.toString();
        if (temp.contains("E")) {
            BigDecimal bigDecimal = new BigDecimal(temp);
            temp = bigDecimal.toPlainString();
        }
        return temp;
    }
}

