/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.TemplateExportParams;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.export.ExcelExportServer;
import org.jeecgframework.poi.excel.export.template.ExcelExportOfTemplateUtil;

public final class ExcelExportUtil {
    private ExcelExportUtil() {
    }

    public static Workbook exportExcel(ExportParams entity, Class<?> pojoClass, Collection<?> dataSet, String[] exportFields) {
        Object workbook = ExcelType.HSSF.equals((Object)entity.getType()) ? new HSSFWorkbook() : (dataSet.size() < 1000 ? new XSSFWorkbook() : new SXSSFWorkbook());
        new ExcelExportServer().createSheet((Workbook)workbook, entity, pojoClass, dataSet, exportFields);
        return workbook;
    }

    public static Workbook exportExcel(ExportParams entity, Class<?> pojoClass, Collection<?> dataSet) {
        Object workbook = ExcelType.HSSF.equals((Object)entity.getType()) ? new HSSFWorkbook() : (dataSet.size() < 1000 ? new XSSFWorkbook() : new SXSSFWorkbook());
        new ExcelExportServer().createSheet((Workbook)workbook, entity, pojoClass, dataSet, null);
        return workbook;
    }

    public static Workbook exportExcel(ExportParams entity, List<ExcelExportEntity> entityList, Collection<? extends Map<?, ?>> dataSet) {
        Object workbook = ExcelType.HSSF.equals((Object)entity.getType()) ? new HSSFWorkbook() : (dataSet.size() < 1000 ? new XSSFWorkbook() : new SXSSFWorkbook());
        new ExcelExportServer().createSheetForMap((Workbook)workbook, entity, entityList, dataSet);
        return workbook;
    }

    public static Workbook exportExcel(List<Map<String, Object>> list, ExcelType type) {
        Object workbook = ExcelType.HSSF.equals((Object)type) ? new HSSFWorkbook() : new XSSFWorkbook();
        for (Map<String, Object> map : list) {
            ExcelExportServer server = new ExcelExportServer();
            server.createSheet((Workbook)workbook, (ExportParams)map.get("title"), (Class)map.get("entity"), (Collection)map.get("data"), null);
        }
        return workbook;
    }

    public static Workbook exportExcel(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        return new ExcelExportOfTemplateUtil().createExcleByTemplate(params, pojoClass, dataSet, map);
    }

    public static Workbook exportExcel(TemplateExportParams params, Map<String, Object> map) {
        return new ExcelExportOfTemplateUtil().createExcleByTemplate(params, null, null, map);
    }
}

