/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.chatgpt.service.impl;

import com.unfbx.chatgpt.OpenAiClient;
import com.unfbx.chatgpt.entity.chat.BaseChatCompletion;
import com.unfbx.chatgpt.entity.chat.BaseMessage;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.ChatCompletionResponse;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.entity.images.Image;
import com.unfbx.chatgpt.entity.images.ImageResponse;
import com.unfbx.chatgpt.entity.images.Item;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jeecg.chatgpt.dto.chat.MultiChatMessage;
import org.jeecg.chatgpt.dto.image.ImageFormat;
import org.jeecg.chatgpt.dto.image.ImageSize;
import org.jeecg.chatgpt.prop.AiChatProperties;
import org.jeecg.chatgpt.service.AiChatService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGptService
implements AiChatService {
    private static final Logger log = LoggerFactory.getLogger(ChatGptService.class);
    OpenAiClient client;
    AiChatProperties aiChatProperties;

    private ChatGptService() {
    }

    public ChatGptService(OpenAiClient openAiClient, AiChatProperties aiChatProperties) {
        this.client = openAiClient;
        this.aiChatProperties = aiChatProperties;
    }

    @Override
    public String completions(String message) {
        if (StringUtils.isEmpty((String)message)) {
            return "";
        }
        Message userMsg = Message.builder().role(BaseMessage.Role.USER).content(message).build();
        ChatCompletion chatCompletion = ((ChatCompletion.ChatCompletionBuilder)ChatCompletion.builder().messages(Collections.singletonList(userMsg)).model(this.aiChatProperties.getModel())).build();
        ChatCompletionResponse chatCompletionResp = this.client.chatCompletion((BaseChatCompletion)chatCompletion);
        return chatCompletionResp.getChoices().stream().map(chatChoice -> chatChoice.getMessage().getContent()).collect(Collectors.joining());
    }

    @Override
    public String multiCompletions(List<MultiChatMessage> messages) {
        if (null == messages || messages.isEmpty()) {
            return "";
        }
        List gptMessage = messages.stream().map(m -> Message.builder().role(m.getRole()).content(m.getContent()).name(m.getName()).build()).collect(Collectors.toList());
        ChatCompletion chatCompletion = ((ChatCompletion.ChatCompletionBuilder)ChatCompletion.builder().messages(gptMessage).model(this.aiChatProperties.getModel())).build();
        ChatCompletionResponse chatCompletionResponse = this.client.chatCompletion((BaseChatCompletion)chatCompletion);
        return chatCompletionResponse.getChoices().stream().map(chatChoice -> chatChoice.getMessage().getContent()).collect(Collectors.joining());
    }

    @Override
    public String genSchemaModules(String prompt) {
        if (StringUtils.isEmpty((String)prompt)) {
            return "";
        }
        String sysMsgContent = "\u6839\u636e\u4e1a\u52a1\u9700\u6c42\u8bbe\u8ba1\u4e00\u5957\u8868\u5355\uff1b\u53ea\u56de\u7b54json\u6570\u636e\u4e0d\u8981\u6709\u5176\u4ed6\u63cf\u8ff0\u3002\u6574\u4f53\u662f\u4e00\u4e2ajson\u6570\u7ec4\uff0c\u6bcf\u4e2a\u8868\u662f\u4e00\u4e2ajson\u5bf9\u8c61\uff0c\u5c5e\u6027\u5305\u542b\uff1a\u4e2d\u6587\u540d\uff08comment)\uff0c\u82f1\u6587\u540d(tableName)\uff0c\u5b57\u6bb5\u5217\u8868(fields);\u5b57\u6bb5\u5217\u8868\u662f\u4e00\u4e2ajson\u6570\u7ec4\uff0c\u5305\u542b\u5b57\u6bb5\u82f1\u6587\u540d(field)\u3001\u5b57\u6bb5\u4e2d\u6587\u540d(comment)\u3001\u5b57\u6bb5\u6570\u636e\u5e93\u7c7b\u578b(fieldDbType)\u3001\u5b57\u6bb5\u7ec4\u4ef6(component)\u3002\u53ef\u7528\u7684\u7ec4\u4ef6\u5305\u542b\uff1ainput\u3001textarea\u3001number\u3001money\u3001radio\u3001checkbox\u3001select\u3001switch\u3001phone\u3001email\u3001file\u3001date\u3001time\u3002\u53c2\u8003json\uff1a[{\\\"tableName\\\":\\\"order\\\",\\\"comment\\\":\\\"\u8ba2\u5355\u8868\\\",\\\"fields\\\":[{\\\"field\\\":\\\"name\\\",\\\"comment\\\":\\\"\u59d3\u540d\\\",\\\"fieldDbType\\\":\\\"varchar\\\",\\\"component\\\":\\\"input\\\"}]}]\u3002";
        MultiChatMessage sysMsg = MultiChatMessage.builder().role(MultiChatMessage.Role.USER).content(sysMsgContent).build();
        MultiChatMessage userMsg = MultiChatMessage.builder().role(MultiChatMessage.Role.USER).content("\u4e1a\u52a1\u9700\u6c42\u5982\u4e0b:" + prompt).build();
        String gptResp = this.multiCompletions(Arrays.asList(sysMsg, userMsg));
        Pattern pattern = Pattern.compile("\\[.*?].*$", 32);
        Matcher matcher = pattern.matcher(gptResp);
        String returnData = "";
        if (matcher.find()) {
            returnData = matcher.group(0);
        }
        return returnData;
    }

    @Override
    public String genArticleWithMd(String prompt) {
        if (StringUtils.isEmpty((String)prompt)) {
            return "";
        }
        ArrayList<MultiChatMessage> messages = new ArrayList<MultiChatMessage>();
        messages.add(MultiChatMessage.builder().role(MultiChatMessage.Role.SYSTEM).content("\u6839\u636e\u6587\u7ae0\u5185\u5bb9\u63cf\u8ff0\u7528MarkDown\u5199\u4e00\u7bc7\u8f6f\u6587\uff1b\u53ea\u8f93\u51faMarkDown,\u4e0d\u8981\u5176\u4ed6\u7684\u63cf\u8ff0\u3002").build());
        messages.add(MultiChatMessage.builder().role(MultiChatMessage.Role.USER).content("\u6587\u7ae0\u5185\u5bb9\u63cf\u8ff0\u5982\u4e0b:" + prompt).build());
        return this.multiCompletions(messages);
    }

    @Override
    public String imageGenerate(String prompt) {
        ImageResponse imageResponse = this.client.genImages(prompt);
        try {
            return ((Item)imageResponse.getData().get(0)).getUrl();
        }
        catch (Exception e) {
            log.error("parse image url error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> imageGenerate(String prompt, Integer n, ImageSize size, ImageFormat format) {
        Image image = Image.builder().prompt(prompt).n(n).responseFormat(format.getFormat()).size(size.getSize()).build();
        ImageResponse imageResponse = this.client.genImages(image);
        try {
            ArrayList<String> list = new ArrayList<String>();
            imageResponse.getData().forEach(imageData -> {
                if (format.equals((Object)ImageFormat.URL)) {
                    list.add(imageData.getUrl());
                } else {
                    list.add(imageData.getB64Json());
                }
            });
            return list;
        }
        catch (Exception e) {
            log.error("parse image url error", (Throwable)e);
            throw e;
        }
    }
}

