/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.wxsendmsg;

import net.sf.json.JSONObject;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.req.WeiXinReqService;
import org.jeewx.api.core.req.model.message.IndustryTemplateAdd;
import org.jeewx.api.core.req.model.message.IndustryTemplateMessageSend;
import org.jeewx.api.core.req.model.message.IndustryTemplateSet;
import org.jeewx.api.core.req.model.message.TemplateData;
import org.jeewx.api.core.req.model.message.TemplateMessage;
import org.jeewx.api.core.util.WeiXinConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwTemplateMessageAPI {
    private static Logger logger = LoggerFactory.getLogger(JwTemplateMessageAPI.class);

    public static String setIndustry(String accessToken, String industry_id1, String industry_id2) throws WexinReqException {
        IndustryTemplateSet s = new IndustryTemplateSet();
        s.setAccess_token(accessToken);
        s.setIndustry_id1(industry_id1);
        s.setIndustry_id2(industry_id2);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(s);
        String msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
        return msg;
    }

    public static String addTemplate(String accessToken, String template_id_short) throws WexinReqException {
        IndustryTemplateAdd t = new IndustryTemplateAdd();
        t.setAccess_token(accessToken);
        t.setTemplate_id_short(template_id_short);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(t);
        String msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
        if ("ok".equalsIgnoreCase(msg)) {
            msg = result.getString("template_id");
        }
        return msg;
    }

    public static String sendTemplateMsg(IndustryTemplateMessageSend industryTemplateMessageSend) throws WexinReqException {
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(industryTemplateMessageSend);
        String msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
        return msg;
    }

    public static void main(String[] args) {
        try {
            String s = "qCU9cEJzhGSJxncRzuxC2Yx5zB4LNysB1_GVTYeRwWtsRydB7c7C6q2WlRFeX7XQg7edLiOQcO5juf0BcMXcWMgR8lEe3qutVMwR88WVCy0";
            System.out.println(s);
            IndustryTemplateMessageSend industryTemplateMessageSend = new IndustryTemplateMessageSend();
            industryTemplateMessageSend.setAccess_token(s);
            industryTemplateMessageSend.setTemplate_id("4m3vrpiSA-CPyL9YqHw2jKDlZSX6Sz65SoMKvA9BV1s");
            industryTemplateMessageSend.setTouser("oR0jFtxn8q_UsSXsKT395GVaG8q0");
            industryTemplateMessageSend.setUrl("www.baidu.com");
            industryTemplateMessageSend.setTopcolor("#ffAADD");
            TemplateMessage data = new TemplateMessage();
            TemplateData first = new TemplateData();
            first.setColor("#173177");
            first.setValue("\u606d\u559c\u4f60\u8d2d\u4e70\u62102323\u529f\uff01");
            TemplateData keynote1 = new TemplateData();
            keynote1.setColor("#173177");
            keynote1.setValue("\u5de7\u514b22\u529b");
            TemplateData keynote2 = new TemplateData();
            keynote2.setColor("39.8\u5143");
            keynote2.setValue("\u606d\u559c\u4f60\u8d2d\u4e70\u6210\u529f\uff01");
            TemplateData keynote3 = new TemplateData();
            keynote3.setColor("#173177");
            keynote3.setValue("2014\u5e749\u670816\u65e5");
            TemplateData remark = new TemplateData();
            remark.setColor("#173177");
            remark.setValue("\u6b22\u8fce\u518d\u6b21\u8d2d\u4e70\uff01");
            data.setFirst(first);
            data.setKeynote1(keynote1);
            data.setKeynote2(keynote2);
            data.setKeynote3(keynote3);
            data.setRemark(remark);
            industryTemplateMessageSend.setData(data);
            s = JwTemplateMessageAPI.sendTemplateMsg(industryTemplateMessageSend);
            System.out.println(s);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }
}

