/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.sqlparser.AbstractSqlProcessor;
import org.jeecgframework.minidao.sqlparser.impl.util.JSqlCountSqlParser;
import org.jeecgframework.minidao.sqlparser.impl.util.JSqlRemoveSqlOrderBy;
import org.jeecgframework.minidao.sqlparser.impl.util.JSqlServerPagesHelper;

public class JsqlparserSqlProcessor
implements AbstractSqlProcessor {
    protected static JSqlCountSqlParser jsqlCountSqlParser = new JSqlCountSqlParser();
    protected static JSqlServerPagesHelper jsqlServerPagesHelper = new JSqlServerPagesHelper();
    protected static JSqlRemoveSqlOrderBy jsqlRemoveSqlOrderBy = new JSqlRemoveSqlOrderBy();

    @Override
    public String getSqlServerPageSql(String sql, MiniDaoPage miniDaoPage) {
        int page = miniDaoPage.getPage();
        int rows = miniDaoPage.getRows();
        int beginNum = (page - 1) * rows;
        String pageSql = jsqlServerPagesHelper.convertToPageSql(sql);
        pageSql = pageSql.replace(String.valueOf(Long.MIN_VALUE), String.valueOf(beginNum));
        pageSql = pageSql.replace(String.valueOf(Long.MAX_VALUE), String.valueOf(rows));
        return pageSql;
    }

    @Override
    public String getCountSql(String sql) {
        return jsqlCountSqlParser.getSmartCountSql(sql);
    }

    @Override
    public String removeOrderBy(String sql) {
        if (sql == null) {
            return null;
        }
        try {
            sql = jsqlRemoveSqlOrderBy.removeOrderBy(sql);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        return sql;
    }

    @Override
    public List<Map<String, Object>> parseSqlFields(String parsedSql) {
        PlainSelect plain;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Select select = null;
        try {
            select = (Select)CCJSqlParserUtil.parse((String)parsedSql, parser -> {
                CCJSqlParser cfr_ignored_0 = (CCJSqlParser)parser.withSquareBracketQuotation(true);
            });
        }
        catch (JSQLParserException jsqlParserException) {
            jsqlParserException.printStackTrace();
        }
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof SetOperationList) {
            SetOperationList selectBodyList = (SetOperationList)selectBody;
            List selects = selectBodyList.getSelects();
            for (int i = 0; i < selects.size(); ++i) {
                plain = (PlainSelect)selects.get(i);
                List<String> tableAndColumns = JsqlparserSqlProcessor.getTableAndColumns(plain);
                JsqlparserSqlProcessor.getMapFiled(list, tableAndColumns);
            }
        }
        if (selectBody instanceof PlainSelect) {
            plain = (PlainSelect)selectBody;
            List<String> tableAndColumns = JsqlparserSqlProcessor.getTableAndColumns(plain);
            JsqlparserSqlProcessor.getMapFiled(list, tableAndColumns);
        }
        return list;
    }

    private static void getMapFiled(List<Map<String, Object>> list, List<String> tableAndColumns) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        for (String str : tableAndColumns) {
            if ("*".equals(str)) continue;
            map.put(str, str);
        }
        list.add(map);
    }

    private static List<String> getTableAndColumns(PlainSelect plain) {
        List selectItems = plain.getSelectItems();
        ArrayList<String> items = new ArrayList<String>();
        if (selectItems != null) {
            for (SelectItem selectItem : selectItems) {
                if (selectItem instanceof SelectExpressionItem) {
                    SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                    String columnName = "";
                    Alias alias = selectExpressionItem.getAlias();
                    Expression expression = selectExpressionItem.getExpression();
                    if (expression instanceof CaseExpression) {
                        columnName = alias.getName();
                    } else if (expression instanceof LongValue || expression instanceof StringValue || expression instanceof DateValue || expression instanceof DoubleValue) {
                        columnName = Objects.nonNull(alias.getName()) ? alias.getName() : expression.getASTNode().jjtGetValue().toString();
                    } else if (expression instanceof TimeKeyExpression) {
                        columnName = alias.getName();
                    } else if (alias != null) {
                        columnName = alias.getName();
                    } else {
                        SimpleNode node = expression.getASTNode();
                        Object value = node.jjtGetValue();
                        if (value instanceof Column) {
                            columnName = ((Column)value).getColumnName();
                        } else if (value instanceof Function) {
                            columnName = value.toString();
                        } else {
                            columnName = String.valueOf(value);
                            columnName = columnName.replace("'", "");
                            columnName = columnName.replace("\"", "");
                            columnName = columnName.replace("`", "");
                        }
                    }
                    columnName = columnName.replace("'", "");
                    columnName = columnName.replace("\"", "");
                    columnName = columnName.replace("`", "");
                    items.add(columnName);
                    continue;
                }
                if (selectItem instanceof AllTableColumns) {
                    AllTableColumns allTableColumns = (AllTableColumns)selectItem;
                    items.add(allTableColumns.toString());
                    continue;
                }
                items.add(selectItem.toString());
            }
        }
        return items;
    }
}

