/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class SingleLaneExecutorService
extends AbstractExecutorService {
    private final ExecutorService base;
    private final Queue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
    private boolean scheduled;
    private boolean shuttingDown;
    private boolean shutDown;
    private final Runnable runner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ((Runnable)SingleLaneExecutorService.this.tasks.peek()).run();
            }
            finally {
                SingleLaneExecutorService singleLaneExecutorService = SingleLaneExecutorService.this;
                synchronized (singleLaneExecutorService) {
                    SingleLaneExecutorService.this.tasks.remove();
                    assert (SingleLaneExecutorService.this.scheduled);
                    if (!SingleLaneExecutorService.this.tasks.isEmpty()) {
                        SingleLaneExecutorService.this.base.submit(this);
                    } else {
                        SingleLaneExecutorService.this.scheduled = false;
                        if (SingleLaneExecutorService.this.shuttingDown) {
                            SingleLaneExecutorService.this.shutDown = true;
                            SingleLaneExecutorService.this.notifyAll();
                        }
                    }
                }
            }
        }
    };

    public SingleLaneExecutorService(ExecutorService base) {
        this.base = base;
    }

    @Override
    public synchronized void shutdown() {
        this.shuttingDown = true;
        if (this.tasks.isEmpty()) {
            this.shutDown = true;
        }
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this.shutDown = true;
        this.shuttingDown = true;
        LinkedList<Runnable> all = new LinkedList<Runnable>(this.tasks);
        this.tasks.clear();
        return all;
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.shuttingDown;
    }

    @Override
    public synchronized boolean isTerminated() {
        return this.shutDown;
    }

    @Override
    public synchronized boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long now = System.nanoTime();
        long end = now + unit.toNanos(timeout);
        while (!this.isTerminated() && end - now > 0L) {
            this.wait(TimeUnit.NANOSECONDS.toMillis(end - now));
            now = System.nanoTime();
        }
        return this.isTerminated();
    }

    @Override
    public synchronized void execute(Runnable command) {
        if (this.shuttingDown) {
            throw new RejectedExecutionException();
        }
        this.tasks.add(command);
        if (!this.scheduled) {
            this.scheduled = true;
            this.base.submit(this.runner);
        }
    }
}

