/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.jenkinsci.remoting.protocol.FilterLayer;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.jenkinsci.remoting.util.ByteBufferQueue;
import org.jenkinsci.remoting.util.ByteBufferUtils;

public class AgentProtocolClientFilterLayer
extends FilterLayer {
    private static final Logger LOGGER = Logger.getLogger(AgentProtocolClientFilterLayer.class.getName());
    private ByteBuffer sendProtocol;
    @GuardedBy(value="sendLock")
    private ByteBufferQueue sendQueue = new ByteBufferQueue(8192);

    public AgentProtocolClientFilterLayer(String name) {
        this.sendProtocol = ByteBufferUtils.wrapUTF8("Protocol:" + name).asReadOnlyBuffer();
    }

    @Override
    public void start() throws IOException {
        try {
            this.doSend(EMPTY_BUFFER);
        }
        catch (ConnectionRefusalException connectionRefusalException) {
            // empty catch block
        }
    }

    @Override
    public void onRecv(@Nonnull ByteBuffer data) throws IOException {
        this.next().onRecv(data);
    }

    @Override
    public synchronized void doSend(@Nonnull ByteBuffer data) throws IOException {
        if (this.sendProtocol.hasRemaining()) {
            this.sendQueue.put(data);
            this.next().doSend(this.sendProtocol);
            return;
        }
        if (this.next() != null) {
            if (this.sendQueue.hasRemaining()) {
                this.sendQueue.put(data);
                this.flushSend(this.sendQueue);
            } else {
                this.next().doSend(data);
            }
            this.completed();
        }
    }
}

