/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.codegen.extensions.ClassFileFactoryFinalizerExtension;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.load.kotlin.ModuleMappingUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.org.objectweb.asm.Type;

public class ClassFileFactory
implements OutputFileCollection {
    private final GenerationState state;
    private final ClassBuilderFactory builderFactory;
    private final List<ClassFileFactoryFinalizerExtension> finalizers;
    private final Map<String, OutAndSourceFileList> generators;
    private boolean isDone;
    private final Set<File> sourceFiles;
    private final PackagePartRegistry packagePartRegistry;

    public ClassFileFactory(@NotNull GenerationState state, @NotNull ClassBuilderFactory builderFactory, @NotNull List<ClassFileFactoryFinalizerExtension> finalizers) {
        if (state == null) {
            ClassFileFactory.$$$reportNull$$$0(0);
        }
        if (builderFactory == null) {
            ClassFileFactory.$$$reportNull$$$0(1);
        }
        if (finalizers == null) {
            ClassFileFactory.$$$reportNull$$$0(2);
        }
        this.generators = Collections.synchronizedMap(new LinkedHashMap());
        this.isDone = false;
        this.sourceFiles = new HashSet<File>();
        this.packagePartRegistry = new PackagePartRegistry();
        this.state = state;
        this.builderFactory = builderFactory;
        this.finalizers = finalizers;
    }

    public GenerationState getGenerationState() {
        return this.state;
    }

    @NotNull
    public PackagePartRegistry getPackagePartRegistry() {
        PackagePartRegistry packagePartRegistry = this.packagePartRegistry;
        if (packagePartRegistry == null) {
            ClassFileFactory.$$$reportNull$$$0(3);
        }
        return packagePartRegistry;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull List<File> sourceFiles) {
        if (origin == null) {
            ClassFileFactory.$$$reportNull$$$0(4);
        }
        if (asmType == null) {
            ClassFileFactory.$$$reportNull$$$0(5);
        }
        if (sourceFiles == null) {
            ClassFileFactory.$$$reportNull$$$0(6);
        }
        ClassBuilder answer = this.builderFactory.newClassBuilder(origin);
        this.generators.put(asmType.getInternalName() + ".class", new ClassBuilderAndSourceFileList(answer, sourceFiles));
        ClassBuilder classBuilder = answer;
        if (classBuilder == null) {
            ClassFileFactory.$$$reportNull$$$0(7);
        }
        return classBuilder;
    }

    public void done() {
        if (!this.isDone) {
            this.isDone = true;
            for (ClassFileFactoryFinalizerExtension extension : this.finalizers) {
                extension.finalizeClassFactory(this);
            }
        }
    }

    public void releaseGeneratedOutput() {
        this.generators.clear();
    }

    public void addSerializedBuiltinsPackageMetadata(String path, final byte[] serialized) {
        this.generators.put(path, new OutAndSourceFileList(CollectionsKt.toList(this.sourceFiles)){

            @Override
            public byte[] asBytes(ClassBuilderFactory factory) {
                return serialized;
            }

            @Override
            public String asText(ClassBuilderFactory factory) {
                throw new UnsupportedOperationException("No string representation for protobuf-serialized metadata");
            }
        });
    }

    public void setModuleMapping(final JvmModuleProtoBuf.Module moduleProto) {
        this.generators.put(JvmCodegenUtil.getMappingFileName(this.state.getModuleName()), new OutAndSourceFileList(CollectionsKt.toList(this.sourceFiles)){

            @Override
            public byte[] asBytes(ClassBuilderFactory factory) {
                int flags = 0;
                if (ClassFileFactory.this.state.getConfig().getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getStrictMetadataVersionSemantics()).booleanValue()) {
                    flags |= 1;
                }
                return ModuleMappingKt.serializeToByteArray(moduleProto, ClassFileFactory.this.getMetadataVersionToUseForModuleMapping(), flags);
            }

            @Override
            public String asText(ClassBuilderFactory factory) {
                return new String(this.asBytes(factory), StandardCharsets.UTF_8);
            }
        });
    }

    @NotNull
    private BinaryVersion getMetadataVersionToUseForModuleMapping() {
        BinaryVersion version2 = this.state.getConfig().getMetadataVersion();
        if (version2.getMajor() == LanguageVersion.KOTLIN_2_0.getMajor() && version2.getMinor() == LanguageVersion.KOTLIN_2_0.getMinor()) {
            return new MetadataVersion(1, 9, 9999);
        }
        BinaryVersion binaryVersion = version2;
        if (binaryVersion == null) {
            ClassFileFactory.$$$reportNull$$$0(8);
        }
        return binaryVersion;
    }

    @Override
    @NotNull
    public List<OutputFile> asList() {
        this.done();
        List<OutputFile> list = this.getCurrentOutput();
        if (list == null) {
            ClassFileFactory.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<OutputFile> getCurrentOutput() {
        List list = CollectionsKt.map(this.generators.keySet(), x$0 -> new OutputClassFile((String)x$0));
        if (list == null) {
            ClassFileFactory.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @Nullable
    public OutputFile get(@NotNull String relativePath) {
        if (relativePath == null) {
            ClassFileFactory.$$$reportNull$$$0(11);
        }
        return this.generators.containsKey(relativePath) ? new OutputClassFile(relativePath) : null;
    }

    @NotNull
    public String createText() {
        String string2 = this.createText(null);
        if (string2 == null) {
            ClassFileFactory.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @NotNull
    public String createText(@Nullable String ignorePrefixPath) {
        StringBuilder answer = new StringBuilder();
        block10: for (OutputFile file2 : this.asList()) {
            if (ignorePrefixPath != null && file2.getRelativePath().startsWith(ignorePrefixPath)) continue;
            File relativePath = new File(file2.getRelativePath());
            answer.append("@").append(relativePath).append('\n');
            switch (FilesKt.getExtension((File)relativePath)) {
                case "class": {
                    answer.append(file2.asText());
                    break;
                }
                case "kotlin_module": {
                    try {
                        ModuleMapping mapping = ModuleMappingUtilKt.loadModuleMapping(ModuleMapping.Companion, file2.asByteArray(), relativePath.getPath(), DeserializationConfiguration.Default.INSTANCE, (Function1<? super MetadataVersion, Unit>)((Function1)version2 -> {
                            throw new ModuleMappingException("Generated module has incompatible JVM metadata version: " + version2);
                        }));
                        for (Map.Entry<String, PackageParts> entry : mapping.getPackageFqName2Parts().entrySet()) {
                            FqName packageFqName = new FqName(entry.getKey());
                            PackageParts packageParts = entry.getValue();
                            answer.append("<package ").append(packageFqName).append(": ").append(packageParts.getParts()).append(">\n");
                        }
                        continue block10;
                    }
                    catch (ModuleMappingException e) {
                        answer.append(relativePath).append(": ").append(e.getMessage()).append("\n");
                        break;
                    }
                }
                default: {
                    answer.append("Unknown output file: ").append(file2);
                }
            }
        }
        String string2 = answer.toString();
        if (string2 == null) {
            ClassFileFactory.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @NotNull
    public Map<String, String> createTextForEachFile() {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (OutputFile file2 : this.asList()) {
            answer.put(file2.getRelativePath(), file2.asText());
        }
        LinkedHashMap<String, String> linkedHashMap = answer;
        if (linkedHashMap == null) {
            ClassFileFactory.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    public void registerSourceFiles(@NotNull Collection<File> files2) {
        if (files2 == null) {
            ClassFileFactory.$$$reportNull$$$0(15);
        }
        for (File file2 : files2) {
            if (file2 == null) continue;
            this.sourceFiles.add(file2);
        }
    }

    public void removeClasses(Set<String> classNamesToRemove) {
        for (String classInternalName : classNamesToRemove) {
            this.generators.remove(classInternalName + ".class");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalizers";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ClassFileFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ClassFileFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagePartRegistry";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadataVersionToUseForModuleMapping";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentOutput";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextForEachFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newVisitor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerSourceFiles";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class OutAndSourceFileList {
        protected final List<File> sourceFiles;

        private OutAndSourceFileList(List<File> sourceFiles) {
            this.sourceFiles = sourceFiles;
        }

        public abstract byte[] asBytes(ClassBuilderFactory var1);

        public abstract String asText(ClassBuilderFactory var1);
    }

    private static final class ClassBuilderAndSourceFileList
    extends OutAndSourceFileList {
        private final ClassBuilder classBuilder;

        private ClassBuilderAndSourceFileList(ClassBuilder classBuilder, List<File> sourceFiles) {
            super(sourceFiles);
            this.classBuilder = classBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] asBytes(ClassBuilderFactory factory) {
            ClassBuilderAndSourceFileList classBuilderAndSourceFileList = this;
            synchronized (classBuilderAndSourceFileList) {
                return factory.asBytes(this.classBuilder);
            }
        }

        @Override
        public String asText(ClassBuilderFactory factory) {
            return factory.asText(this.classBuilder);
        }
    }

    private class OutputClassFile
    implements OutputFile {
        private final String relativeClassFilePath;

        public OutputClassFile(String relativeClassFilePath) {
            this.relativeClassFilePath = relativeClassFilePath;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            String string2 = this.relativeClassFilePath;
            if (string2 == null) {
                OutputClassFile.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public List<File> getSourceFiles() {
            OutAndSourceFileList pair = (OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath);
            if (pair == null) {
                throw new IllegalStateException("No record for binary file " + this.relativeClassFilePath);
            }
            List<File> list = pair.sourceFiles;
            if (list == null) {
                OutputClassFile.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public byte[] asByteArray() {
            byte[] byArray;
            try {
                byArray = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asBytes(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
            if (byArray == null) {
                OutputClassFile.$$$reportNull$$$0(2);
            }
            return byArray;
        }

        @Override
        @NotNull
        public String asText() {
            String string2;
            try {
                string2 = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asText(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
            if (string2 == null) {
                OutputClassFile.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @NotNull
        public String toString() {
            String string2 = this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
            if (string2 == null) {
                OutputClassFile.$$$reportNull$$$0(4);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asByteArray";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ModuleMappingException
    extends RuntimeException {
        public ModuleMappingException(String message2) {
            super(message2);
        }
    }
}

